/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.sonarsource.sonarlint.core.plugin.PluginKeyUtils;

public final class PluginManifest {
    public static final String KEY_ATTRIBUTE = "Plugin-Key";
    public static final String MAIN_CLASS_ATTRIBUTE = "Plugin-Class";
    public static final String NAME_ATTRIBUTE = "Plugin-Name";
    public static final String VERSION_ATTRIBUTE = "Plugin-Version";
    public static final String SONAR_VERSION_ATTRIBUTE = "Sonar-Version";
    public static final String DEPENDENCIES_ATTRIBUTE = "Plugin-Dependencies";
    public static final String REQUIRE_PLUGINS_ATTRIBUTE = "Plugin-RequirePlugins";
    public static final String USE_CHILD_FIRST_CLASSLOADER = "Plugin-ChildFirstClassLoader";
    public static final String BASE_PLUGIN = "Plugin-Base";
    public static final String IMPLEMENTATION_BUILD = "Implementation-Build";
    public static final String SONARLINT_SUPPORTED = "SonarLint-Supported";
    private String key;
    private String name;
    private String mainClass;
    private String version;
    private String sonarVersion;
    private String[] dependencies = new String[0];
    private boolean useChildFirstClassLoader = false;
    private String basePlugin;
    private String implementationBuild;
    private String[] requirePlugins = new String[0];
    private Boolean sonarLintSupported;

    public PluginManifest(Path jarPath) throws IOException {
        this();
        try (JarFile jar = new JarFile(jarPath.toFile());){
            if (jar.getManifest() != null) {
                this.loadManifest(jar.getManifest());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read plugin manifest from jar : " + jarPath.toAbsolutePath(), e);
        }
    }

    public PluginManifest(Manifest manifest) {
        this();
        this.loadManifest(manifest);
    }

    public PluginManifest() {
    }

    private void loadManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.key = PluginKeyUtils.sanitize(attributes.getValue(KEY_ATTRIBUTE));
        this.mainClass = attributes.getValue(MAIN_CLASS_ATTRIBUTE);
        this.name = attributes.getValue(NAME_ATTRIBUTE);
        this.version = attributes.getValue(VERSION_ATTRIBUTE);
        this.sonarVersion = attributes.getValue(SONAR_VERSION_ATTRIBUTE);
        this.useChildFirstClassLoader = StringUtils.equalsIgnoreCase(attributes.getValue(USE_CHILD_FIRST_CLASSLOADER), "true");
        String slSupported = attributes.getValue(SONARLINT_SUPPORTED);
        this.sonarLintSupported = slSupported != null ? Boolean.valueOf(StringUtils.equalsIgnoreCase(slSupported, "true")) : null;
        this.basePlugin = attributes.getValue(BASE_PLUGIN);
        this.implementationBuild = attributes.getValue(IMPLEMENTATION_BUILD);
        String deps = attributes.getValue(DEPENDENCIES_ATTRIBUTE);
        this.dependencies = StringUtils.split(StringUtils.defaultString(deps), ' ');
        String requires = attributes.getValue(REQUIRE_PLUGINS_ATTRIBUTE);
        this.requirePlugins = StringUtils.split(StringUtils.defaultString(requires), ',');
    }

    public String getKey() {
        return this.key;
    }

    public PluginManifest setKey(String key) {
        this.key = key;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PluginManifest setName(String name) {
        this.name = name;
        return this;
    }

    public String[] getRequirePlugins() {
        return this.requirePlugins != null ? (String[])this.requirePlugins.clone() : null;
    }

    public PluginManifest setRequirePlugins(@Nullable String[] requirePlugins) {
        this.requirePlugins = requirePlugins != null ? (String[])requirePlugins.clone() : null;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public PluginManifest setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getSonarVersion() {
        return this.sonarVersion;
    }

    public PluginManifest setSonarVersion(String sonarVersion) {
        this.sonarVersion = sonarVersion;
        return this;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public PluginManifest setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public String[] getDependencies() {
        return this.dependencies != null ? (String[])this.dependencies.clone() : null;
    }

    public PluginManifest setDependencies(@Nullable String[] dependencies) {
        this.dependencies = dependencies != null ? (String[])dependencies.clone() : null;
        return this;
    }

    public boolean isUseChildFirstClassLoader() {
        return this.useChildFirstClassLoader;
    }

    public PluginManifest setUseChildFirstClassLoader(boolean useChildFirstClassLoader) {
        this.useChildFirstClassLoader = useChildFirstClassLoader;
        return this;
    }

    public String getBasePlugin() {
        return this.basePlugin;
    }

    public PluginManifest setBasePlugin(String key) {
        this.basePlugin = key;
        return this;
    }

    @CheckForNull
    public Boolean isSonarLintSupported() {
        return this.sonarLintSupported;
    }

    public PluginManifest setSonarLintSupported(Boolean sonarLintSupported) {
        this.sonarLintSupported = sonarLintSupported;
        return this;
    }

    public String getImplementationBuild() {
        return this.implementationBuild;
    }

    public PluginManifest setImplementationBuild(String implementationBuild) {
        this.implementationBuild = implementationBuild;
        return this;
    }

    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public boolean isValid() {
        return StringUtils.isNotBlank(this.key) && StringUtils.isNotBlank(this.version);
    }
}

