/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.classloader.Mask;

class PluginClassLoaderDef {
    private final String basePluginKey;
    private final Map<String, String> mainClassesByPluginKey = new HashMap<String, String>();
    private final List<File> files = new ArrayList<File>();
    private final Mask mask = new Mask();
    private boolean selfFirstStrategy = false;

    PluginClassLoaderDef(String basePluginKey) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(basePluginKey));
        this.basePluginKey = basePluginKey;
    }

    String getBasePluginKey() {
        return this.basePluginKey;
    }

    List<File> getFiles() {
        return this.files;
    }

    void addFiles(Collection<File> f) {
        this.files.addAll(f);
    }

    Mask getExportMask() {
        return this.mask;
    }

    boolean isSelfFirstStrategy() {
        return this.selfFirstStrategy;
    }

    void setSelfFirstStrategy(boolean selfFirstStrategy) {
        this.selfFirstStrategy = selfFirstStrategy;
    }

    Map<String, String> getMainClassesByPluginKey() {
        return this.mainClassesByPluginKey;
    }

    void addMainClass(String pluginKey, @Nullable String mainClass) {
        if (!Strings.isNullOrEmpty(mainClass)) {
            this.mainClassesByPluginKey.put(pluginKey, mainClass);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginClassLoaderDef that = (PluginClassLoaderDef)o;
        return this.basePluginKey.equals(that.basePluginKey);
    }

    public int hashCode() {
        return this.basePluginKey.hashCode();
    }
}

