/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonarsource.sonarlint.core.client.api.exceptions.StorageException;
import org.sonarsource.sonarlint.core.plugin.PluginIndex;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCache;

public class PluginCacheLoader {
    private static final ImmutableSet<String> PLUGIN_WHITELIST = ImmutableSet.of("xoo", "java", "javascript", "php", "python", "cobol", new String[]{"abap", "plsql", "swift", "rpg", "cpp", "pli"});
    private static final String IMPLEMENTED_SQ_API = "6.7";
    private static final Logger LOG = Loggers.get(PluginCacheLoader.class);
    private final PluginCache fileCache;
    private final PluginIndex pluginIndex;

    public PluginCacheLoader(PluginCache fileCache, PluginIndex pluginIndex) {
        this.fileCache = fileCache;
        this.pluginIndex = pluginIndex;
    }

    public Map<String, PluginInfo> load() {
        return this.loadPlugins(this.pluginIndex.references());
    }

    private Map<String, PluginInfo> loadPlugins(List<PluginIndex.PluginReference> pluginReferences) {
        HashMap<String, PluginInfo> infosByKey = new HashMap<String, PluginInfo>();
        Profiler profiler = Profiler.create(LOG).startDebug("Load plugins");
        for (PluginIndex.PluginReference ref : pluginReferences) {
            Path jarFilePath = this.getFromCache(ref);
            PluginInfo info = PluginInfo.create(jarFilePath);
            Boolean sonarLintSupported = info.isSonarLintSupported();
            if (!info.isCompatibleWith(IMPLEMENTED_SQ_API)) {
                LOG.debug("Plugin {} need SonarQube plugin API {} while SonarLint supports only up to {}. Skip it.", info.getKey(), info.getMinimalSqVersion(), IMPLEMENTED_SQ_API);
                break;
            }
            if (sonarLintSupported != null && sonarLintSupported.booleanValue() || PluginCacheLoader.isWhitelisted(info.getKey())) {
                infosByKey.put(info.getKey(), info);
                continue;
            }
            LOG.debug("Plugin {} is not compatible with SonarLint. Skip it.", (Object)info.getKey());
        }
        profiler.stopDebug();
        return infosByKey;
    }

    public static boolean isWhitelisted(String pluginKey) {
        return PLUGIN_WHITELIST.contains(pluginKey);
    }

    private Path getFromCache(PluginIndex.PluginReference pluginReference) {
        Path jar;
        try {
            jar = this.fileCache.get(pluginReference.getFilename(), pluginReference.getHash());
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to find plugin " + pluginReference.getFilename() + " in the cache", e);
        }
        if (jar == null) {
            throw new StorageException("Couldn't find plugin '" + pluginReference.getFilename() + "' in the cache. Please update the binding", false);
        }
        return jar;
    }
}

