/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.notifications;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sonarsource.sonarlint.core.client.api.common.NotificationConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.notifications.SonarQubeNotificationListener;
import org.sonarsource.sonarlint.core.notifications.NotificationChecker;
import org.sonarsource.sonarlint.core.notifications.NotificationCheckerFactory;
import org.sonarsource.sonarlint.core.notifications.NotificationTimerTask;

public class SonarQubeNotifications {
    static final int DELAY = 60000;
    private static final Object LOCK = new Object();
    private static SonarQubeNotifications singleton;
    private final List<NotificationConfiguration> configuredNotifications = new CopyOnWriteArrayList<NotificationConfiguration>();
    private Timer timer;
    private NotificationTimerTask task;
    private final NotificationCheckerFactory checkerFactory;

    SonarQubeNotifications(Timer timer, NotificationTimerTask task, NotificationCheckerFactory checkerFactory) {
        this.timer = timer;
        this.task = task;
        this.checkerFactory = checkerFactory;
        this.timer.scheduleAtFixedRate((TimerTask)task, 60000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SonarQubeNotifications get() {
        Object object = LOCK;
        synchronized (object) {
            if (singleton == null) {
                Timer timer = new Timer("Notifications timer", true);
                NotificationTimerTask timerTask = new NotificationTimerTask();
                singleton = new SonarQubeNotifications(timer, timerTask, new NotificationCheckerFactory());
            }
            return singleton;
        }
    }

    public void register(NotificationConfiguration configuration) {
        this.configuredNotifications.add(configuration);
        this.task.setProjects(this.configuredNotifications);
    }

    public void remove(SonarQubeNotificationListener listener) {
        this.configuredNotifications.removeIf(p -> p.listener().equals(listener));
        this.task.setProjects(this.configuredNotifications);
    }

    public boolean isSupported(ServerConfiguration serverConfig) {
        NotificationChecker checker = this.checkerFactory.create(serverConfig);
        return checker.isSupported();
    }

    public void stop() {
        this.timer.cancel();
        this.timer = null;
        this.task = null;
        this.configuredNotifications.clear();
    }
}

