/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.util.LoggedErrorHandler;

class LogCallbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final InheritableThreadLocal<LogOutput> tlTtarget = new InheritableThreadLocal();
    private final InheritableThreadLocal<LoggedErrorHandler> errorHandler = new InheritableThreadLocal();
    private final Appender<ILoggingEvent> defaultAppender;

    LogCallbackAppender(Appender<ILoggingEvent> defaultAppender) {
        this.defaultAppender = defaultAppender;
    }

    public void setTarget(@Nullable LogOutput target) {
        this.tlTtarget.set(target);
    }

    public void setErrorHandler(@Nullable LoggedErrorHandler errorHandler) {
        this.errorHandler.set(errorHandler);
    }

    @Override
    protected void append(ILoggingEvent event) {
        String msg;
        LogOutput target = (LogOutput)this.tlTtarget.get();
        if (target == null) {
            this.defaultAppender.doAppend(event);
            return;
        }
        if (event.getThrowableProxy() == null) {
            msg = event.getFormattedMessage();
        } else {
            ExtendedThrowableProxyConverter throwableConverter = new ExtendedThrowableProxyConverter();
            throwableConverter.start();
            msg = event.getFormattedMessage() + "\n" + throwableConverter.convert(event);
            throwableConverter.stop();
        }
        this.handleErrors(event);
        target.log(msg, LogCallbackAppender.translate(event.getLevel()));
    }

    private void handleErrors(ILoggingEvent event) {
        LoggedErrorHandler handler;
        if (event.getLevel().equals(Level.ERROR) && (handler = (LoggedErrorHandler)this.errorHandler.get()) != null) {
            handler.handleError(event.getFormattedMessage());
            if (event.getThrowableProxy() != null) {
                handler.handleException(event.getThrowableProxy().getClassName());
            }
        }
    }

    private static LogOutput.Level translate(Level level) {
        switch (level.toInt()) {
            case 40000: {
                return LogOutput.Level.ERROR;
            }
            case 30000: {
                return LogOutput.Level.WARN;
            }
            case 20000: {
                return LogOutput.Level.INFO;
            }
            case 5000: {
                return LogOutput.Level.TRACE;
            }
        }
        return LogOutput.Level.DEBUG;
    }
}

