/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.util.Collections;
import java.util.function.Function;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.container.model.DefaultRuleDetails;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.StringUtils;

public class StorageRuleDetailsReader
implements Function<String, RuleDetails> {
    private StorageReader storageReader;

    public StorageRuleDetailsReader(StorageReader storageReader) {
        this.storageReader = storageReader;
    }

    @Override
    public RuleDetails apply(String ruleKeyStr) {
        Sonarlint.Rules rulesFromStorage = this.storageReader.readRules();
        RuleKey ruleKey = RuleKey.parse(ruleKeyStr);
        Sonarlint.Rules.Rule rule = rulesFromStorage.getRulesByKeyMap().get(ruleKeyStr);
        if (rule == null) {
            throw new IllegalArgumentException("Unable to find rule with key " + ruleKey);
        }
        String type = StringUtils.isEmpty(rule.getType()) ? null : rule.getType();
        return new DefaultRuleDetails(ruleKeyStr, rule.getName(), rule.getHtmlDesc(), rule.getSeverity(), type, rule.getLang(), Collections.emptySet(), rule.getHtmlNote());
    }
}

