/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalStorageStatus;
import org.sonarsource.sonarlint.core.container.model.DefaultGlobalStorageStatus;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class StorageReader {
    private final StoragePaths storagePaths;
    private final GlobalStorageStatus storageStatus;

    public StorageReader(StoragePaths storagePaths) {
        this.storagePaths = storagePaths;
        this.storageStatus = this.initStorageStatus();
    }

    @CheckForNull
    public GlobalStorageStatus getGlobalStorageStatus() {
        return this.storageStatus;
    }

    @CheckForNull
    private GlobalStorageStatus initStorageStatus() {
        Path storageStatusPath = this.storagePaths.getStorageStatusPath();
        if (Files.exists(storageStatusPath, new LinkOption[0])) {
            Sonarlint.StorageStatus currentStorageStatus = ProtobufUtil.readFile(storageStatusPath, Sonarlint.StorageStatus.parser());
            boolean stale = !currentStorageStatus.getStorageVersion().equals("1");
            String version = null;
            if (!stale) {
                Sonarlint.ServerInfos serverInfoFromStorage = ProtobufUtil.readFile(this.storagePaths.getServerInfosPath(), Sonarlint.ServerInfos.parser());
                version = serverInfoFromStorage.getVersion();
            }
            return new DefaultGlobalStorageStatus(version, new Date(currentStorageStatus.getUpdateTimestamp()), stale);
        }
        return null;
    }

    public Sonarlint.ServerInfos readServerInfos() {
        return ProtobufUtil.readFile(this.storagePaths.getServerInfosPath(), Sonarlint.ServerInfos.parser());
    }

    public Sonarlint.ServerIssues readServerIsses(String moduleKey) {
        return ProtobufUtil.readFile(this.storagePaths.getServerIssuesPath(moduleKey), Sonarlint.ServerIssues.parser());
    }

    public Sonarlint.Rules readRules() {
        return ProtobufUtil.readFile(this.storagePaths.getRulesPath(), Sonarlint.Rules.parser());
    }

    public Sonarlint.ActiveRules readActiveRules(String qProfileKey) {
        return ProtobufUtil.readFile(this.storagePaths.getActiveRulesPath(qProfileKey), Sonarlint.ActiveRules.parser());
    }

    public Sonarlint.QProfiles readQProfiles() {
        return ProtobufUtil.readFile(this.storagePaths.getQProfilesPath(), Sonarlint.QProfiles.parser());
    }

    public Sonarlint.GlobalProperties readGlobalProperties() {
        return ProtobufUtil.readFile(this.storagePaths.getGlobalPropertiesPath(), Sonarlint.GlobalProperties.parser());
    }

    public Sonarlint.PluginReferences readPluginReferences() {
        return ProtobufUtil.readFile(this.storagePaths.getPluginReferencesPath(), Sonarlint.PluginReferences.parser());
    }

    public Sonarlint.ModuleConfiguration readModuleConfig(String moduleKey) {
        return ProtobufUtil.readFile(this.storagePaths.getModuleConfigurationPath(moduleKey), Sonarlint.ModuleConfiguration.parser());
    }

    public Sonarlint.ModuleList readModuleList() {
        return ProtobufUtil.readFile(this.storagePaths.getModuleListPath(), Sonarlint.ModuleList.parser());
    }
}

