/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.util.StringUtils;

public class StoragePaths {
    private static final int MAX_FOLDER_NAME_SIZE = 255;
    public static final String STORAGE_VERSION = "1";
    public static final String PLUGIN_REFERENCES_PB = "plugin_references.pb";
    public static final String PROPERTIES_PB = "properties.pb";
    public static final String MODULE_CONFIGURATION_PB = "configuration.pb";
    public static final String RULES_PB = "rules.pb";
    public static final String QUALITY_PROFILES_PB = "quality_profiles.pb";
    public static final String STORAGE_STATUS_PB = "storage_status.pb";
    public static final String SERVER_INFO_PB = "server_info.pb";
    public static final String ACTIVE_RULES_FOLDER = "active_rules";
    public static final String MODULE_LIST_PB = "module_list.pb";
    public static final String SERVER_ISSUES_DIR = "server_issues";
    private final Path serverStorageRoot;
    private final Path globalStorageRoot;
    private final Path moduleStorageRoot;

    public StoragePaths(ConnectedGlobalConfiguration configuration) {
        this.serverStorageRoot = configuration.getStorageRoot().resolve(StoragePaths.encodeForFs(configuration.getServerId()));
        this.globalStorageRoot = this.serverStorageRoot.resolve("global");
        this.moduleStorageRoot = this.serverStorageRoot.resolve("modules");
    }

    public Path getServerStorageRoot() {
        return this.serverStorageRoot;
    }

    public Path getGlobalStorageRoot() {
        return this.globalStorageRoot;
    }

    public Path getModuleStorageRoot(String moduleKey) {
        return this.moduleStorageRoot.resolve(StoragePaths.encodeForFs(moduleKey));
    }

    public static String encodeForFs(String name) {
        String encoded;
        try {
            encoded = URLEncoder.encode(name, StandardCharsets.UTF_8.name()).replace("*", "%2A");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to encode name: " + name, e);
        }
        if (encoded.length() > 255) {
            String md5 = StringUtils.md5(name);
            return encoded.substring(0, 255 - md5.length()) + md5;
        }
        return encoded;
    }

    public Path getModuleConfigurationPath(String moduleKey) {
        return this.getModuleStorageRoot(moduleKey).resolve(MODULE_CONFIGURATION_PB);
    }

    public Path getModuleUpdateStatusPath(String moduleKey) {
        return this.getModuleStorageRoot(moduleKey).resolve(STORAGE_STATUS_PB);
    }

    public Path getPluginReferencesPath() {
        return this.getGlobalStorageRoot().resolve(PLUGIN_REFERENCES_PB);
    }

    public Path getGlobalPropertiesPath() {
        return this.getGlobalStorageRoot().resolve(PROPERTIES_PB);
    }

    public Path getModuleListPath() {
        return this.getGlobalStorageRoot().resolve(MODULE_LIST_PB);
    }

    public Path getRulesPath() {
        return this.getGlobalStorageRoot().resolve(RULES_PB);
    }

    public Path getQProfilesPath() {
        return this.getGlobalStorageRoot().resolve(QUALITY_PROFILES_PB);
    }

    public Path getActiveRulesPath(String qProfileKey) {
        return this.getGlobalStorageRoot().resolve(ACTIVE_RULES_FOLDER).resolve(StoragePaths.encodeForFs(qProfileKey) + ".pb");
    }

    public Path getStorageStatusPath() {
        return this.getGlobalStorageRoot().resolve(STORAGE_STATUS_PB);
    }

    public Path getServerInfosPath() {
        return this.getGlobalStorageRoot().resolve(SERVER_INFO_PB);
    }

    public Path getServerIssuesPath(String moduleKey) {
        return this.getModuleStorageRoot(moduleKey).resolve(SERVER_ISSUES_DIR);
    }
}

