/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.SonarQubeVersion;
import org.sonar.api.internal.ApiVersion;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.UriReader;
import org.sonar.api.utils.Version;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalStorageStatus;
import org.sonarsource.sonarlint.core.container.ComponentContainer;
import org.sonarsource.sonarlint.core.container.connected.IssueStoreFactory;
import org.sonarsource.sonarlint.core.container.connected.validate.PluginVersionChecker;
import org.sonarsource.sonarlint.core.container.global.ExtensionInstaller;
import org.sonarsource.sonarlint.core.container.global.GlobalTempFolderProvider;
import org.sonarsource.sonarlint.core.container.storage.AllModulesReader;
import org.sonarsource.sonarlint.core.container.storage.GlobalUpdateStatusReader;
import org.sonarsource.sonarlint.core.container.storage.IssueStoreReader;
import org.sonarsource.sonarlint.core.container.storage.ModuleStorageStatusReader;
import org.sonarsource.sonarlint.core.container.storage.SonarQubeRulesProvider;
import org.sonarsource.sonarlint.core.container.storage.StorageAnalyzer;
import org.sonarsource.sonarlint.core.container.storage.StorageContainerHandler;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.container.storage.StoragePluginIndexProvider;
import org.sonarsource.sonarlint.core.container.storage.StorageQProfilesProvider;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.container.storage.StorageRuleDetailsReader;
import org.sonarsource.sonarlint.core.container.storage.StorageRulesProvider;
import org.sonarsource.sonarlint.core.plugin.DefaultPluginJarExploder;
import org.sonarsource.sonarlint.core.plugin.PluginCacheLoader;
import org.sonarsource.sonarlint.core.plugin.PluginClassloaderFactory;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.PluginLoader;
import org.sonarsource.sonarlint.core.plugin.PluginRepository;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCacheProvider;

public class StorageContainer
extends ComponentContainer {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainer.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();

    public static StorageContainer create(ConnectedGlobalConfiguration globalConfig) {
        StorageContainer container = new StorageContainer();
        container.add(globalConfig);
        return container;
    }

    @Override
    protected void doBeforeStart() {
        Version version = ApiVersion.load(System2.INSTANCE);
        this.add(StorageContainerHandler.class, StoragePaths.class, StorageReader.class, new GlobalTempFolderProvider(), PluginRepository.class, PluginCacheLoader.class, PluginVersionChecker.class, PluginLoader.class, PluginClassloaderFactory.class, DefaultPluginJarExploder.class, StoragePluginIndexProvider.class, new PluginCacheProvider(), AllModulesReader.class, IssueStoreReader.class, GlobalUpdateStatusReader.class, ModuleStorageStatusReader.class, StorageRuleDetailsReader.class, IssueStoreFactory.class, StorageAnalyzer.class, UriReader.class, ExtensionInstaller.class, new StorageRulesProvider(), new StorageQProfilesProvider(), new SonarQubeRulesProvider(), new SonarQubeVersion(version), SonarRuntimeImpl.forSonarLint(version), System2.INSTANCE);
    }

    @Override
    protected void doAfterStart() {
        ConnectedGlobalConfiguration config = this.getComponentByType(ConnectedGlobalConfiguration.class);
        GlobalStorageStatus updateStatus = this.getComponentByType(StorageContainerHandler.class).getGlobalStorageStatus();
        if (updateStatus != null) {
            LOG.info("Using storage for server '{}' (last update {})", (Object)config.getServerId(), (Object)DATE_FORMAT.format(updateStatus.getLastUpdateDate()));
            this.installPlugins();
        } else {
            LOG.warn("No storage for server '{}'. Please update.", (Object)config.getServerId());
        }
    }

    protected void installPlugins() {
        PluginRepository pluginRepository = this.getComponentByType(PluginRepository.class);
        for (PluginInfo pluginInfo : pluginRepository.getPluginInfos()) {
            Plugin instance = pluginRepository.getPluginInstance(pluginInfo.getKey());
            this.addExtension(pluginInfo, instance);
        }
    }

    public StorageContainerHandler getHandler() {
        return this.getComponentByType(StorageContainerHandler.class);
    }
}

