/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.exceptions.MessageException;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class SonarQubeActiveRulesProvider
extends ProviderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SonarQubeActiveRulesProvider.class);
    private ActiveRules activeRules;

    public ActiveRules provide(Sonarlint.Rules storageRules, Sonarlint.QProfiles qProfiles, StorageReader storageReader, Rules rules, ConnectedAnalysisConfiguration analysisConfiguration, Languages languages) {
        if (this.activeRules == null) {
            Map<String, String> qProfilesByLanguage = SonarQubeActiveRulesProvider.loadQualityProfilesFromStorage(qProfiles, storageReader, analysisConfiguration);
            ActiveRulesBuilder builder = new ActiveRulesBuilder();
            for (Map.Entry<String, String> entry : qProfilesByLanguage.entrySet()) {
                String language = entry.getKey();
                if (languages.get(language) == null) continue;
                String qProfileKey = entry.getValue();
                Sonarlint.QProfiles.QProfile qProfile = qProfiles.getQprofilesByKeyOrThrow(qProfileKey);
                if (qProfile.getActiveRuleCount() == 0L) {
                    LOG.debug("  * {}: {} (0 rules)", (Object)language, (Object)qProfileKey);
                    continue;
                }
                Sonarlint.ActiveRules activeRulesFromStorage = storageReader.readActiveRules(qProfileKey);
                LOG.debug("  * {}: {} ({} rules)", language, qProfileKey, activeRulesFromStorage.getActiveRulesByKeyMap().size());
                for (Sonarlint.ActiveRules.ActiveRule activeRule : activeRulesFromStorage.getActiveRulesByKeyMap().values()) {
                    SonarQubeActiveRulesProvider.createNewActiveRule(builder, activeRule, storageRules, language, rules);
                }
            }
            this.activeRules = builder.build();
        }
        return this.activeRules;
    }

    private static void createNewActiveRule(ActiveRulesBuilder builder, Sonarlint.ActiveRules.ActiveRule activeRule, Sonarlint.Rules storageRules, String language, Rules rules) {
        Sonarlint.Rules.Rule storageRule;
        RuleKey ruleKey = RuleKey.of(activeRule.getRepo(), activeRule.getKey());
        Rule rule = rules.find(ruleKey);
        try {
            storageRule = storageRules.getRulesByKeyOrThrow(ruleKey.toString());
        }
        catch (IllegalArgumentException e) {
            throw new MessageException("Unknown active rule in the quality profile of the project. Please update the SonarQube server binding.");
        }
        NewActiveRule newActiveRule = builder.create(ruleKey).setLanguage(language).setName(rule.name()).setInternalKey(rule.internalKey()).setSeverity(activeRule.getSeverity());
        if (!StringUtils.isEmpty(storageRule.getTemplateKey())) {
            RuleKey templateRuleKey = RuleKey.parse(storageRule.getTemplateKey());
            newActiveRule.setTemplateRuleKey(templateRuleKey.rule());
        }
        for (Map.Entry<String, String> param : activeRule.getParamsMap().entrySet()) {
            newActiveRule.setParam(param.getKey(), param.getValue());
        }
        newActiveRule.activate();
    }

    private static Map<String, String> loadQualityProfilesFromStorage(Sonarlint.QProfiles qProfiles, StorageReader storageReader, ConnectedAnalysisConfiguration analysisConfiguration) {
        Map<String, String> qProfilesByLanguage;
        if (analysisConfiguration.moduleKey() == null) {
            LOG.debug("Use default quality profiles:");
            qProfilesByLanguage = qProfiles.getDefaultQProfilesByLanguageMap();
        } else {
            LOG.debug("Quality profiles:");
            qProfilesByLanguage = storageReader.readModuleConfig(analysisConfiguration.moduleKey()).getQprofilePerLanguageMap();
        }
        return qProfilesByLanguage;
    }
}

