/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonarsource.sonarlint.core.client.api.connected.ServerIssue;
import org.sonarsource.sonarlint.core.container.connected.IssueStore;
import org.sonarsource.sonarlint.core.container.connected.IssueStoreFactory;
import org.sonarsource.sonarlint.core.container.model.DefaultServerIssue;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class IssueStoreReader {
    private final IssueStoreFactory issueStoreFactory;
    private final StorageReader storageReader;
    private final StoragePaths storagePaths;

    public IssueStoreReader(IssueStoreFactory issueStoreFactory, StorageReader storageReader, StoragePaths storagePaths) {
        this.issueStoreFactory = issueStoreFactory;
        this.storageReader = storageReader;
        this.storagePaths = storagePaths;
    }

    public List<ServerIssue> getServerIssues(String moduleKey, String filePath) {
        String fileKey = this.getFileKey(moduleKey, filePath);
        Path serverIssuesPath = this.storagePaths.getServerIssuesPath(moduleKey);
        IssueStore issueStore = this.issueStoreFactory.apply(serverIssuesPath);
        List<ScannerInput.ServerIssue> loadedIssues = issueStore.load(fileKey);
        return loadedIssues.stream().map(pbIssue -> IssueStoreReader.transformIssue(pbIssue, moduleKey, filePath)).collect(Collectors.toList());
    }

    public String getFileKey(String moduleKey, String filePath) {
        Sonarlint.ModuleConfiguration moduleConfig = this.storageReader.readModuleConfig(moduleKey);
        if (moduleConfig == null) {
            throw new IllegalStateException("module not in storage: " + moduleKey);
        }
        Map<String, String> modulePaths = moduleConfig.getModulePathByKeyMap();
        String subModuleKey = moduleKey;
        int prefixLen = 0;
        for (Map.Entry<String, String> entry : modulePaths.entrySet()) {
            String entryModuleKey = entry.getKey();
            String entryPath = entry.getValue();
            if (entryPath.isEmpty() || !filePath.startsWith(entryPath) || prefixLen > entryPath.length()) continue;
            subModuleKey = entryModuleKey;
            prefixLen = entryPath.length() + 1;
        }
        String relativeFilePath = filePath.substring(prefixLen);
        return subModuleKey + ":" + relativeFilePath;
    }

    private static ServerIssue transformIssue(ScannerInput.ServerIssue pbIssue, String moduleKey, String filePath) {
        DefaultServerIssue issue = new DefaultServerIssue();
        issue.setAssigneeLogin(pbIssue.getAssigneeLogin());
        issue.setAssigneeLogin(pbIssue.getAssigneeLogin());
        issue.setChecksum(pbIssue.getChecksum());
        issue.setLine(pbIssue.getLine());
        issue.setFilePath(filePath);
        issue.setModuleKey(moduleKey);
        issue.setManualSeverity(pbIssue.getManualSeverity());
        issue.setMessage(pbIssue.getMsg());
        issue.setSeverity(pbIssue.getSeverity().name());
        if (pbIssue.hasType()) {
            issue.setType(pbIssue.getType());
        }
        issue.setCreationDate(Instant.ofEpochMilli(pbIssue.getCreationDate()));
        issue.setResolution(pbIssue.getResolution());
        issue.setKey(pbIssue.getKey());
        issue.setRuleKey(pbIssue.getRuleRepository() + ":" + pbIssue.getRuleKey());
        return issue;
    }
}

