/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.standalone.rule;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.profiles.ProfileDefinition;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.ValidationMessages;
import org.sonarsource.sonarlint.core.container.standalone.rule.StandaloneRuleDefinitionsLoader;

public class StandaloneActiveRulesProvider {
    private ActiveRules singleton = null;
    private final StandaloneRuleDefinitionsLoader ruleDefsLoader;
    private final ProfileDefinition[] profileDefinitions;

    public StandaloneActiveRulesProvider(StandaloneRuleDefinitionsLoader ruleDefsLoader, ProfileDefinition[] profileDefinitions) {
        this.ruleDefsLoader = ruleDefsLoader;
        this.profileDefinitions = profileDefinitions;
    }

    public StandaloneActiveRulesProvider(StandaloneRuleDefinitionsLoader ruleDefsLoader) {
        this(ruleDefsLoader, new ProfileDefinition[0]);
    }

    public ActiveRules provide() {
        if (this.singleton == null) {
            this.singleton = this.createActiveRules();
        }
        return this.singleton;
    }

    private ActiveRules createActiveRules() {
        ActiveRulesBuilder builder = new ActiveRulesBuilder();
        ListMultimap<String, RulesProfile> profilesByLanguage = StandaloneActiveRulesProvider.profilesByLanguage(this.profileDefinitions);
        for (String language : profilesByLanguage.keySet()) {
            List<RulesProfile> defs = profilesByLanguage.get(language);
            StandaloneActiveRulesProvider.registerProfilesForLanguage(builder, language, defs);
        }
        for (RulesDefinition.Repository repo : this.ruleDefsLoader.getContext().repositories()) {
            for (RulesDefinition.Rule rule : repo.rules()) {
                if (!rule.activatedByDefault()) continue;
                NewActiveRule newAr = builder.create(RuleKey.of(repo.key(), rule.key())).setLanguage(repo.language()).setName(rule.name()).setSeverity(rule.severity()).setInternalKey(rule.internalKey());
                for (RulesDefinition.Param param : rule.params()) {
                    newAr.setParam(param.key(), param.defaultValue());
                }
                newAr.activate();
            }
        }
        return builder.build();
    }

    private static void registerProfilesForLanguage(ActiveRulesBuilder builder, String language, List<RulesProfile> defs) {
        for (Map.Entry<String, Collection<RulesProfile>> entry : StandaloneActiveRulesProvider.profilesByName(defs).entrySet()) {
            String name = entry.getKey();
            if (!"Sonar way".equals(name)) continue;
            StandaloneActiveRulesProvider.registerProfile(builder, language, entry);
        }
    }

    private static void registerProfile(ActiveRulesBuilder builder, String language, Map.Entry<String, Collection<RulesProfile>> entry) {
        for (RulesProfile rp : entry.getValue()) {
            for (ActiveRule ar : rp.getActiveRules()) {
                NewActiveRule newAr = builder.create(RuleKey.of(ar.getRepositoryKey(), ar.getRuleKey())).setLanguage(language).setName(ar.getRule().getName()).setSeverity(ar.getSeverity().name()).setInternalKey(ar.getConfigKey());
                for (ActiveRuleParam param : ar.getActiveRuleParams()) {
                    newAr.setParam(param.getKey(), param.getValue());
                }
                newAr.activate();
            }
        }
    }

    private static ListMultimap<String, RulesProfile> profilesByLanguage(ProfileDefinition[] profileDefinitions) {
        ArrayListMultimap<String, RulesProfile> byLang = ArrayListMultimap.create();
        for (ProfileDefinition definition : profileDefinitions) {
            ValidationMessages validation = ValidationMessages.create();
            RulesProfile profile = definition.createProfile(validation);
            if (profile == null || validation.hasErrors()) continue;
            byLang.put(StringUtils.lowerCase(profile.getLanguage()), profile);
        }
        return byLang;
    }

    private static Map<String, Collection<RulesProfile>> profilesByName(List<RulesProfile> profiles) {
        return Multimaps.index(profiles, profile -> profile != null ? profile.getName() : null).asMap();
    }
}

