/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.standalone.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RuleQuery;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.sonarlint.core.container.standalone.rule.StandaloneRuleDefinitionsLoader;

public class RuleFinderCompatibility
implements RuleFinder {
    private static Function<RulesDefinition.Rule, Rule> ruleTransformer = RuleFinderCompatibility::toRule;
    private final RulesDefinition.Context context;

    public RuleFinderCompatibility(StandaloneRuleDefinitionsLoader rules) {
        this.context = rules.getContext();
    }

    @Override
    public Rule findById(int ruleId) {
        throw new UnsupportedOperationException("Unable to find rule by id");
    }

    @Override
    public Rule findByKey(String repositoryKey, String key) {
        return this.findByKey(RuleKey.of(repositoryKey, key));
    }

    @Override
    public Rule findByKey(RuleKey key) {
        RulesDefinition.Repository repository = this.context.repository(key.repository());
        return repository != null ? RuleFinderCompatibility.toRule(repository.rule(key.rule())) : null;
    }

    @Override
    public Rule find(RuleQuery query) {
        Collection<Rule> all = this.findAll(query);
        if (all.size() > 1) {
            throw new IllegalArgumentException("Non unique result for rule query: " + ReflectionToStringBuilder.toString(query, ToStringStyle.SHORT_PREFIX_STYLE));
        }
        if (all.isEmpty()) {
            return null;
        }
        return all.iterator().next();
    }

    @Override
    public Collection<Rule> findAll(RuleQuery query) {
        if (query.getConfigKey() != null) {
            if (query.getRepositoryKey() != null && query.getKey() == null) {
                throw new UnsupportedOperationException("Unable to find rule by internal key");
            }
        } else if (query.getRepositoryKey() != null) {
            if (query.getKey() != null) {
                return this.byKey(query);
            }
            return this.byRepository(query);
        }
        throw new UnsupportedOperationException("Unable to find rule by query");
    }

    private Collection<Rule> byRepository(RuleQuery query) {
        RulesDefinition.Repository repository = this.context.repository(query.getRepositoryKey());
        return repository != null ? (Collection)repository.rules().stream().map(ruleTransformer).collect(Collectors.toList()) : Collections.emptyList();
    }

    private Collection<Rule> byKey(RuleQuery query) {
        Rule rule = this.findByKey(query.getRepositoryKey(), query.getKey());
        return rule != null ? Arrays.asList(rule) : Collections.emptyList();
    }

    @CheckForNull
    private static Rule toRule(@Nullable RulesDefinition.Rule ar) {
        return ar == null ? null : RuleFinderCompatibility.toRuleNotNull(ar);
    }

    private static Rule toRuleNotNull(RulesDefinition.Rule ruleDef) {
        Rule rule = Rule.create(ruleDef.repository().key(), ruleDef.key()).setName(ruleDef.name()).setSeverity(RulePriority.valueOf(ruleDef.severity())).setLanguage(ruleDef.repository().language()).setIsTemplate(ruleDef.template()).setConfigKey(ruleDef.internalKey());
        for (RulesDefinition.Param param : ruleDef.params()) {
            rule.createParameter(param.key()).setDefaultValue(param.defaultValue()).setDescription(param.description());
        }
        return rule;
    }
}

