/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.validate;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import org.apache.commons.lang.StringUtils;
import org.sonarsource.sonarlint.core.client.api.connected.ValidationResult;
import org.sonarsource.sonarlint.core.client.api.exceptions.UnsupportedServerException;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.validate.DefaultValidationResult;
import org.sonarsource.sonarlint.core.plugin.Version;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class ServerVersionAndStatusChecker {
    private static final String MIN_SQ_VERSION = "5.6";
    private final SonarLintWsClient wsClient;

    public ServerVersionAndStatusChecker(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public Sonarlint.ServerInfos checkVersionAndStatus() {
        return this.checkVersionAndStatus(MIN_SQ_VERSION);
    }

    public Sonarlint.ServerInfos checkVersionAndStatus(String minVersion) {
        Sonarlint.ServerInfos serverStatus = this.fetchServerInfos();
        if (!"UP".equals(serverStatus.getStatus())) {
            throw new IllegalStateException(ServerVersionAndStatusChecker.serverNotReady(serverStatus));
        }
        Version serverVersion = Version.create(serverStatus.getVersion());
        if (serverVersion.compareToIgnoreQualifier(Version.create(minVersion)) < 0) {
            throw new UnsupportedServerException(ServerVersionAndStatusChecker.unsupportedVersion(serverStatus, minVersion));
        }
        return serverStatus;
    }

    private static String unsupportedVersion(Sonarlint.ServerInfos serverStatus, String minVersion) {
        return "SonarQube server has version " + serverStatus.getVersion() + ". Version should be greater or equal to " + minVersion;
    }

    private static String serverNotReady(Sonarlint.ServerInfos serverStatus) {
        return "Server not ready (" + serverStatus.getStatus() + ")";
    }

    public ValidationResult validateStatusAndVersion() {
        return this.validateStatusAndVersion(MIN_SQ_VERSION);
    }

    public ValidationResult validateStatusAndVersion(String minVersion) {
        Sonarlint.ServerInfos serverStatus = this.fetchServerInfos();
        if (!"UP".equals(serverStatus.getStatus())) {
            return new DefaultValidationResult(false, ServerVersionAndStatusChecker.serverNotReady(serverStatus));
        }
        Version serverVersion = Version.create(serverStatus.getVersion());
        if (serverVersion.compareToIgnoreQualifier(Version.create(minVersion)) < 0) {
            return new DefaultValidationResult(false, ServerVersionAndStatusChecker.unsupportedVersion(serverStatus, minVersion));
        }
        return new DefaultValidationResult(true, "Compatible and ready");
    }

    private Sonarlint.ServerInfos fetchServerInfos() {
        Throwable throwable = null;
        try (WsResponse response = this.wsClient.rawGet("api/system/status");){
            if (!response.isSuccessful()) {
                if (response.code() == 404) {
                    Sonarlint.ServerInfos serverInfos = this.tryFromDeprecatedApi(response);
                    return serverInfos;
                }
                throw SonarLintWsClient.handleError(response);
            }
            String responseStr = response.content();
            try {
                Sonarlint.ServerInfos.Builder builder = Sonarlint.ServerInfos.newBuilder();
                JsonFormat.parser().merge(responseStr, (Message.Builder)builder);
                Sonarlint.ServerInfos serverInfos = builder.build();
                return serverInfos;
            }
            catch (InvalidProtocolBufferException e) {
                try {
                    throw new IllegalStateException("Unable to parse server infos from: " + StringUtils.abbreviate(responseStr, 100), e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private Sonarlint.ServerInfos tryFromDeprecatedApi(WsResponse originalReponse) {
        try (WsResponse responseFallback = this.wsClient.rawGet("api/server/version");){
            if (!responseFallback.isSuccessful()) {
                throw SonarLintWsClient.handleError(originalReponse);
            }
            String responseStr = responseFallback.content();
            Sonarlint.ServerInfos.Builder builder = Sonarlint.ServerInfos.newBuilder();
            builder.setStatus("UP");
            builder.setVersion(StringUtils.trimToEmpty(responseStr));
            Sonarlint.ServerInfos serverInfos = builder.build();
            return serverInfos;
        }
    }
}

