/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.validate;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.CheckForNull;

public class PluginVersionChecker {
    public static final String MIN_VERSIONS_FILE = "/plugins_min_versions.txt";
    private static final String STREAM_SUPPORT_FILE = "/plugins_stream_support.txt";
    private final Properties minimalPluginVersions = new Properties();
    private final Properties streamSupportVersions = new Properties();

    public PluginVersionChecker() {
        try {
            this.minimalPluginVersions.load(this.getClass().getResourceAsStream(MIN_VERSIONS_FILE));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load minimum plugin versions", e);
        }
        try {
            this.streamSupportVersions.load(this.getClass().getResourceAsStream(STREAM_SUPPORT_FILE));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load list of plugins supporting file content stream", e);
        }
    }

    @CheckForNull
    public String getMinimumVersion(String key) {
        return this.minimalPluginVersions.getProperty(key);
    }

    @CheckForNull
    public String getMinimumStreamSupportVersion(String key) {
        return this.streamSupportVersions.getProperty(key);
    }
}

