/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update.check;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.client.api.connected.StorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.container.connected.update.ModuleConfigurationDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.SettingsDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.check.DefaultStorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.container.connected.update.check.GlobalSettingsUpdateChecker;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;

public class ModuleStorageUpdateChecker {
    private static final Logger LOG = Loggers.get(ModuleStorageUpdateChecker.class);
    private final StorageReader storageReader;
    private final ModuleConfigurationDownloader moduleConfigurationDownloader;
    private final SettingsDownloader settingsDownloader;

    public ModuleStorageUpdateChecker(StorageReader storageReader, ModuleConfigurationDownloader moduleConfigurationDownloader, SettingsDownloader settingsDownloader) {
        this.storageReader = storageReader;
        this.moduleConfigurationDownloader = moduleConfigurationDownloader;
        this.settingsDownloader = settingsDownloader;
    }

    public StorageUpdateCheckResult checkForUpdates(String moduleKey, ProgressWrapper progress) {
        DefaultStorageUpdateCheckResult result = new DefaultStorageUpdateCheckResult();
        String serverVersion = this.storageReader.readServerInfos().getVersion();
        Sonarlint.GlobalProperties globalProps = this.settingsDownloader.fetchGlobalSettings(serverVersion);
        Sonarlint.ModuleConfiguration serverModuleConfiguration = this.moduleConfigurationDownloader.fetchModuleConfiguration(serverVersion, moduleKey, globalProps, progress);
        Sonarlint.ModuleConfiguration storageModuleConfiguration = this.storageReader.readModuleConfig(moduleKey);
        ModuleStorageUpdateChecker.checkForSettingsUpdates(result, serverModuleConfiguration, storageModuleConfiguration);
        ModuleStorageUpdateChecker.checkForQualityProfilesUpdates(result, serverModuleConfiguration, storageModuleConfiguration);
        return result;
    }

    private static void checkForQualityProfilesUpdates(DefaultStorageUpdateCheckResult result, Sonarlint.ModuleConfiguration serverModuleConfiguration, Sonarlint.ModuleConfiguration storageModuleConfiguration) {
        MapDifference<String, String> qProfileDiff = Maps.difference(storageModuleConfiguration.getQprofilePerLanguageMap(), serverModuleConfiguration.getQprofilePerLanguageMap());
        if (!qProfileDiff.areEqual()) {
            for (Map.Entry<String, String> entry : qProfileDiff.entriesOnlyOnLeft().entrySet()) {
                LOG.debug("Quality profile for language '{}' removed", (Object)entry.getKey());
            }
            for (Map.Entry<String, String> entry : qProfileDiff.entriesOnlyOnRight().entrySet()) {
                LOG.debug("Quality profile for language '{}' added with value '{}'", (Object)entry.getKey(), (Object)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : qProfileDiff.entriesDiffering().entrySet()) {
                LOG.debug("Quality profile for language '{}' changed from '{}' to '{}'", entry.getKey(), ((MapDifference.ValueDifference)entry.getValue()).leftValue(), ((MapDifference.ValueDifference)entry.getValue()).rightValue());
            }
            if (!qProfileDiff.entriesOnlyOnRight().isEmpty() || !qProfileDiff.entriesDiffering().isEmpty()) {
                result.appendToChangelog("Quality profiles configuration changed");
            }
        }
    }

    private static void checkForSettingsUpdates(DefaultStorageUpdateCheckResult result, Sonarlint.ModuleConfiguration serverModuleConfiguration, Sonarlint.ModuleConfiguration storageModuleConfiguration) {
        MapDifference<String, String> propDiff = Maps.difference(GlobalSettingsUpdateChecker.filter(storageModuleConfiguration.getPropertiesMap()), GlobalSettingsUpdateChecker.filter(serverModuleConfiguration.getPropertiesMap()));
        if (!propDiff.areEqual()) {
            result.appendToChangelog("Project settings updated");
            for (Map.Entry<String, String> entry : propDiff.entriesOnlyOnLeft().entrySet()) {
                LOG.debug("Property '{}' removed", (Object)entry.getKey());
            }
            for (Map.Entry<String, String> entry : propDiff.entriesOnlyOnRight().entrySet()) {
                LOG.debug("Property '{}' added with value '{}'", (Object)entry.getKey(), (Object)GlobalSettingsUpdateChecker.formatValue(entry.getKey(), entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : propDiff.entriesDiffering().entrySet()) {
                LOG.debug("Value of property '{}' changed from '{}' to '{}'", entry.getKey(), GlobalSettingsUpdateChecker.formatLeftDiff(entry.getKey(), (String)((MapDifference.ValueDifference)entry.getValue()).leftValue(), (String)((MapDifference.ValueDifference)entry.getValue()).rightValue()), GlobalSettingsUpdateChecker.formatRightDiff(entry.getKey(), (String)((MapDifference.ValueDifference)entry.getValue()).leftValue(), (String)((MapDifference.ValueDifference)entry.getValue()).rightValue()));
            }
        }
    }
}

