/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update.check;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.container.connected.update.SettingsDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.check.DefaultStorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class GlobalSettingsUpdateChecker {
    private static final int MAX_VALUE_LENGTH = 20;
    private static final Logger LOG = Loggers.get(GlobalSettingsUpdateChecker.class);
    private static final Set<String> WHITELIST = ImmutableSet.of("sonar.inclusions", "sonar.test.inclusions", "sonar.exclusions", "sonar.test.exclusions", "sonar.global.exclusions", "sonar.global.test.exclusions", new String[0]);
    private final StorageReader storageReader;
    private final SettingsDownloader globalPropertiesDownloader;

    public GlobalSettingsUpdateChecker(StorageReader storageManager, SettingsDownloader globalPropertiesDownloader) {
        this.storageReader = storageManager;
        this.globalPropertiesDownloader = globalPropertiesDownloader;
    }

    public void checkForUpdates(String serverVersion, DefaultStorageUpdateCheckResult result) {
        Sonarlint.GlobalProperties serverGlobalProperties = this.globalPropertiesDownloader.fetchGlobalSettings(serverVersion);
        Sonarlint.GlobalProperties storageGlobalProperties = this.storageReader.readGlobalProperties();
        MapDifference<String, String> propDiff = Maps.difference(GlobalSettingsUpdateChecker.filter(storageGlobalProperties.getPropertiesMap()), GlobalSettingsUpdateChecker.filter(serverGlobalProperties.getPropertiesMap()));
        if (!propDiff.areEqual()) {
            result.appendToChangelog("Global settings updated");
            for (Map.Entry<String, String> entry : propDiff.entriesOnlyOnLeft().entrySet()) {
                LOG.debug("Property '{}' removed", (Object)entry.getKey());
            }
            for (Map.Entry<String, String> entry : propDiff.entriesOnlyOnRight().entrySet()) {
                LOG.debug("Property '{}' added with value '{}'", (Object)entry.getKey(), (Object)GlobalSettingsUpdateChecker.formatValue(entry.getKey(), entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : propDiff.entriesDiffering().entrySet()) {
                LOG.debug("Value of property '{}' changed from '{}' to '{}'", entry.getKey(), GlobalSettingsUpdateChecker.formatLeftDiff(entry.getKey(), (String)((MapDifference.ValueDifference)entry.getValue()).leftValue(), (String)((MapDifference.ValueDifference)entry.getValue()).rightValue()), GlobalSettingsUpdateChecker.formatRightDiff(entry.getKey(), (String)((MapDifference.ValueDifference)entry.getValue()).leftValue(), (String)((MapDifference.ValueDifference)entry.getValue()).rightValue()));
            }
        }
    }

    static String formatValue(String key, String value) {
        if (key.endsWith(".secured")) {
            return "******";
        }
        return StringUtils.abbreviate(value, 20);
    }

    static String formatRightDiff(String key, String left, String right) {
        if (right.length() <= 20) {
            return GlobalSettingsUpdateChecker.formatValue(key, right);
        }
        String diff = StringUtils.difference(left, right);
        if (right.startsWith(diff)) {
            return GlobalSettingsUpdateChecker.formatValue(key, diff);
        }
        return GlobalSettingsUpdateChecker.formatValue(key, "..." + diff);
    }

    static String formatLeftDiff(String key, String left, String right) {
        if (left.length() <= 20) {
            return GlobalSettingsUpdateChecker.formatValue(key, left);
        }
        String diff = StringUtils.difference(right, left);
        if (left.startsWith(diff)) {
            return GlobalSettingsUpdateChecker.formatValue(key, diff);
        }
        return GlobalSettingsUpdateChecker.formatValue(key, "..." + diff);
    }

    static Map<String, String> filter(Map<String, String> propertiesMap) {
        return propertiesMap.entrySet().stream().filter(entry -> WHITELIST.contains(entry.getKey()) || ((String)entry.getKey()).startsWith("sonar.issue.ignore") || ((String)entry.getKey()).startsWith("sonar.issue.enforce") || ((String)entry.getKey()).endsWith(".license.secured")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

