/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.rule.RuleKey;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Rules;
import org.sonarsource.sonarlint.core.client.api.util.FileUtils;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;
import org.sonarsource.sonarlint.core.util.StringUtils;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class RulesDownloader {
    static final String RULES_SEARCH_URL = "/api/rules/search.protobuf?f=repo,name,severity,lang,htmlDesc,htmlNote,internalKey,isTemplate,templateKey,actives&statuses=BETA,DEPRECATED,READY";
    private final SonarLintWsClient wsClient;

    public RulesDownloader(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public void fetchRulesTo(Path destDir, ProgressWrapper progress) {
        Sonarlint.Rules.Builder rulesBuilder = Sonarlint.Rules.newBuilder();
        HashMap<String, Sonarlint.ActiveRules.Builder> activeRulesBuildersByQProfile = new HashMap<String, Sonarlint.ActiveRules.Builder>();
        this.fetchRulesAndActiveRules(rulesBuilder, activeRulesBuildersByQProfile, progress);
        Path activeRulesDir = destDir.resolve("active_rules");
        FileUtils.mkdirs((Path)activeRulesDir);
        for (Map.Entry entry : activeRulesBuildersByQProfile.entrySet()) {
            ProtobufUtil.writeToFile(((Sonarlint.ActiveRules.Builder)entry.getValue()).build(), activeRulesDir.resolve(StoragePaths.encodeForFs((String)entry.getKey()) + ".pb"));
        }
        ProtobufUtil.writeToFile(rulesBuilder.build(), destDir.resolve("rules.pb"));
    }

    private void fetchRulesAndActiveRules(Sonarlint.Rules.Builder rulesBuilder, Map<String, Sonarlint.ActiveRules.Builder> activeRulesBuildersByQProfile, ProgressWrapper progress) {
        int page = 0;
        int pageSize = 500;
        int loaded = 0;
        while (true) {
            Rules.SearchResponse response = RulesDownloader.loadFromStream(this.wsClient.get(this.getUrl(++page, pageSize)));
            RulesDownloader.readPage(rulesBuilder, activeRulesBuildersByQProfile, response);
            loaded = (int)((long)loaded + response.getPs());
            if (response.getTotal() <= (long)loaded) break;
            progress.setProgressAndCheckCancel("Loading page " + page, (float)loaded / (float)response.getTotal());
        }
    }

    private String getUrl(int page, int pageSize) {
        StringBuilder builder = new StringBuilder(1024);
        builder.append(RULES_SEARCH_URL);
        if (this.wsClient.getOrganizationKey() != null) {
            builder.append("&organization=").append(StringUtils.urlEncode(this.wsClient.getOrganizationKey()));
        }
        builder.append("&p=").append(page);
        builder.append("&ps=").append(pageSize);
        return builder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Rules.SearchResponse loadFromStream(WsResponse response) {
        try (InputStream is = response.contentStream();){
            Rules.SearchResponse searchResponse = Rules.SearchResponse.parseFrom(is);
            return searchResponse;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load rules", e);
        }
    }

    private static void readPage(Sonarlint.Rules.Builder rulesBuilder, Map<String, Sonarlint.ActiveRules.Builder> activeRulesBuildersByQProfile, Rules.SearchResponse response) {
        Sonarlint.Rules.Rule.Builder ruleBuilder = Sonarlint.Rules.Rule.newBuilder();
        for (Rules.Rule r : response.getRulesList()) {
            RuleKey ruleKey = RuleKey.parse(r.getKey());
            ruleBuilder.clear();
            ruleBuilder.setRepo(ruleKey.repository()).setKey(ruleKey.rule()).setName(r.getName()).setSeverity(r.getSeverity()).setLang(r.getLang()).setInternalKey(r.getInternalKey()).setHtmlDesc(r.getHtmlDesc()).setHtmlNote(r.getHtmlNote()).setIsTemplate(r.getIsTemplate()).setTemplateKey(r.getTemplateKey());
            String type = RulesDownloader.typeToString(r.getType());
            if (type != null) {
                ruleBuilder.setType(type);
            }
            rulesBuilder.putRulesByKey(r.getKey(), ruleBuilder.build());
        }
        Sonarlint.ActiveRules.ActiveRule.Builder arBuilder = Sonarlint.ActiveRules.ActiveRule.newBuilder();
        for (Map.Entry<String, Rules.ActiveList> entry : response.getActives().getActives().entrySet()) {
            RuleKey ruleKey = RuleKey.parse(entry.getKey());
            for (Rules.Active ar : entry.getValue().getActiveListList()) {
                String qProfileKey = ar.getQProfile();
                if (!activeRulesBuildersByQProfile.containsKey(qProfileKey)) {
                    activeRulesBuildersByQProfile.put(qProfileKey, Sonarlint.ActiveRules.newBuilder());
                }
                arBuilder.clear();
                arBuilder.setRepo(ruleKey.repository());
                arBuilder.setKey(ruleKey.rule());
                arBuilder.setSeverity(ar.getSeverity());
                for (Rules.Active.Param p : ar.getParamsList()) {
                    arBuilder.putParams(p.getKey(), p.getValue());
                }
                activeRulesBuildersByQProfile.get(qProfileKey).putActiveRulesByKey(entry.getKey(), arBuilder.build());
            }
        }
        for (Map.Entry<String, GeneratedMessage> entry : response.getQProfiles().getQProfiles().entrySet()) {
            if (activeRulesBuildersByQProfile.containsKey(((Rules.QProfile)entry.getValue()).getName())) continue;
            activeRulesBuildersByQProfile.put(((Rules.QProfile)entry.getValue()).getName(), Sonarlint.ActiveRules.newBuilder());
        }
    }

    @CheckForNull
    private static String typeToString(Common.RuleType type) {
        switch (type) {
            case BUG: 
            case CODE_SMELL: 
            case VULNERABILITY: {
                return type.toString();
            }
        }
        return null;
    }
}

