/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.sonarlint.core.client.api.connected.SonarAnalyzer;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.plugin.Version;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCache;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class PluginReferencesDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(PluginReferencesDownloader.class);
    private final PluginCache pluginCache;
    private final SonarLintWsClient wsClient;

    public PluginReferencesDownloader(SonarLintWsClient wsClient, PluginCache pluginCache) {
        this.wsClient = wsClient;
        this.pluginCache = pluginCache;
    }

    public Sonarlint.PluginReferences fetchPlugins(List<SonarAnalyzer> analyzers) {
        Sonarlint.PluginReferences.Builder builder = Sonarlint.PluginReferences.newBuilder();
        for (SonarAnalyzer analyzer : analyzers) {
            if (!analyzer.sonarlintCompatible()) {
                LOG.debug("Plugin {} is not compatible with SonarLint. Skip it.", (Object)analyzer.key());
                continue;
            }
            if (!PluginReferencesDownloader.checkVersion(analyzer.version(), analyzer.minimumVersion())) continue;
            builder.addReference(Sonarlint.PluginReferences.PluginReference.newBuilder().setKey(analyzer.key()).setHash(analyzer.hash()).setFilename(analyzer.filename()).build());
        }
        return builder.build();
    }

    private static boolean checkVersion(@Nullable String version, @Nullable String minVersion) {
        if (version != null && minVersion != null) {
            Version minimalVersion;
            Version v = Version.create(version);
            return v.compareTo(minimalVersion = Version.create(minVersion)) >= 0;
        }
        return true;
    }

    public Sonarlint.PluginReferences fetchPluginsTo(Path dest, List<SonarAnalyzer> analyzers) {
        Sonarlint.PluginReferences refs = this.fetchPlugins(analyzers);
        for (Sonarlint.PluginReferences.PluginReference ref : refs.getReferenceList()) {
            this.pluginCache.get(ref.getFilename(), ref.getHash(), new SonarQubeServerPluginDownloader(ref.getKey()));
        }
        ProtobufUtil.writeToFile(refs, dest.resolve("plugin_references.pb"));
        return refs;
    }

    private class SonarQubeServerPluginDownloader
    implements PluginCache.Copier {
        private String key;

        SonarQubeServerPluginDownloader(String key) {
            this.key = key;
        }

        @Override
        public void copy(String filename, Path toFile) throws IOException {
            String url = String.format("/deploy/plugins/%s/%s", this.key, filename);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Download plugin {} to {}", (Object)filename, (Object)toFile);
            } else {
                LOG.info("Download {}", (Object)filename);
            }
            WsResponse response = PluginReferencesDownloader.this.wsClient.get(url);
            try (InputStream stream = response.contentStream();){
                FileUtils.copyInputStreamToFile(stream, toFile.toFile());
            }
        }
    }
}

