/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.sonarsource.sonarlint.core.client.api.connected.SonarAnalyzer;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.validate.PluginVersionChecker;
import org.sonarsource.sonarlint.core.container.model.DefaultSonarAnalyzer;
import org.sonarsource.sonarlint.core.plugin.PluginCacheLoader;
import org.sonarsource.sonarlint.core.plugin.Version;
import org.sonarsource.sonarlint.core.util.VersionUtils;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class PluginListDownloader {
    public static final String WS_PATH = "/api/plugins/installed";
    public static final String WS_PATH_LTS = "/deploy/plugins/index.txt";
    private final SonarLintWsClient wsClient;
    private final PluginVersionChecker pluginVersionChecker;

    public PluginListDownloader(SonarLintWsClient wsClient, PluginVersionChecker pluginVersionChecker) {
        this.wsClient = wsClient;
        this.pluginVersionChecker = pluginVersionChecker;
    }

    public List<SonarAnalyzer> downloadPluginList(String serverVersion) {
        String responseStr;
        LinkedList<SonarAnalyzer> analyzers = new LinkedList<SonarAnalyzer>();
        boolean compatibleFlagPresent = Version.create(serverVersion).compareToIgnoreQualifier(Version.create("6.0")) >= 0;
        try (WsResponse response = this.wsClient.get(WS_PATH_LTS);){
            responseStr = response.content();
        }
        Scanner scanner = new Scanner(responseStr);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String[] fields = StringUtils.split(line, ",");
            String[] nameAndHash = StringUtils.split(fields[fields.length - 1], "|");
            String key = fields[0];
            String filename = nameAndHash[0];
            String hash = nameAndHash[1];
            String version = VersionUtils.getJarVersion(filename);
            String minVersion = this.pluginVersionChecker.getMinimumVersion(key);
            boolean sonarlintCompatible = PluginCacheLoader.isWhitelisted(key) || !compatibleFlagPresent || "true".equals(fields[1]);
            DefaultSonarAnalyzer analyzer = new DefaultSonarAnalyzer(key, filename, hash, version, sonarlintCompatible);
            analyzer.minimumVersion(minVersion);
            analyzers.add(analyzer);
        }
        scanner.close();
        return analyzers;
    }
}

