/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.sonarqube.ws.QualityProfiles;
import org.sonarsource.sonarlint.core.client.api.exceptions.ProjectNotFoundException;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.exceptions.NotFoundException;
import org.sonarsource.sonarlint.core.util.StringUtils;

public class ModuleQualityProfilesDownloader {
    private final SonarLintWsClient wsClient;

    public ModuleQualityProfilesDownloader(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public List<QualityProfiles.SearchWsResponse.QualityProfile> fetchModuleQualityProfiles(String moduleKey) {
        QualityProfiles.SearchWsResponse qpResponse;
        String baseUrl = "/api/qualityprofiles/search.protobuf?projectKey=" + StringUtils.urlEncode(moduleKey);
        String organizationKey = this.wsClient.getOrganizationKey();
        if (organizationKey != null) {
            baseUrl = baseUrl + "&organization=" + StringUtils.urlEncode(organizationKey);
        }
        try (InputStream contentStream = this.wsClient.get(baseUrl).contentStream();){
            qpResponse = QualityProfiles.SearchWsResponse.parseFrom(contentStream);
        }
        catch (NotFoundException e) {
            throw new ProjectNotFoundException(moduleKey, organizationKey);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load module quality profiles", e);
        }
        return qpResponse.getProfilesList();
    }
}

