/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import java.util.Map;
import org.sonarqube.ws.QualityProfiles;
import org.sonarsource.sonarlint.core.container.connected.update.ModuleHierarchyDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.ModuleQualityProfilesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.SettingsDownloader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;

public class ModuleConfigurationDownloader {
    private final ModuleHierarchyDownloader moduleHierarchyDownloader;
    private final ModuleQualityProfilesDownloader moduleQualityProfilesDownloader;
    private final SettingsDownloader settingsDownloader;

    public ModuleConfigurationDownloader(ModuleHierarchyDownloader moduleHierarchyDownloader, ModuleQualityProfilesDownloader moduleQualityProfilesDownloader, SettingsDownloader settingsDownloader) {
        this.moduleHierarchyDownloader = moduleHierarchyDownloader;
        this.moduleQualityProfilesDownloader = moduleQualityProfilesDownloader;
        this.settingsDownloader = settingsDownloader;
    }

    public Sonarlint.ModuleConfiguration fetchModuleConfiguration(String serverVersion, String moduleKey, Sonarlint.GlobalProperties globalProps, ProgressWrapper progress) {
        Sonarlint.ModuleConfiguration.Builder builder = Sonarlint.ModuleConfiguration.newBuilder();
        this.fetchProjectQualityProfiles(moduleKey, builder);
        progress.setProgressAndCheckCancel("Fetching module settings", 0.1f);
        this.settingsDownloader.fetchProjectSettings(serverVersion, moduleKey, globalProps, builder);
        progress.setProgressAndCheckCancel("Fetching module hierarchy", 0.2f);
        this.fetchModuleHierarchy(moduleKey, builder, progress.subProgress(0.2f, 1.0f, "Fetching module hierarchy"));
        return builder.build();
    }

    private void fetchModuleHierarchy(String moduleKey, Sonarlint.ModuleConfiguration.Builder builder, ProgressWrapper progress) {
        Map<String, String> moduleHierarchy = this.moduleHierarchyDownloader.fetchModuleHierarchy(moduleKey, progress);
        builder.putAllModulePathByKey(moduleHierarchy);
    }

    private void fetchProjectQualityProfiles(String moduleKey, Sonarlint.ModuleConfiguration.Builder builder) {
        for (QualityProfiles.SearchWsResponse.QualityProfile qp : this.moduleQualityProfilesDownloader.fetchModuleQualityProfiles(moduleKey)) {
            builder.putQprofilePerLanguage(qp.getLanguage(), qp.getKey());
        }
    }
}

