/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import com.google.protobuf.Parser;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.update.IssueDownloader;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.util.StringUtils;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class IssueDownloaderImpl
implements IssueDownloader {
    private final SonarLintWsClient wsClient;

    public IssueDownloaderImpl(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public List<ScannerInput.ServerIssue> apply(String key) {
        try (WsResponse response = this.wsClient.rawGet(IssueDownloaderImpl.getIssuesUrl(key));){
            if (response.code() == 403 || response.code() == 404) {
                List<ScannerInput.ServerIssue> list = Collections.emptyList();
                return list;
            }
            if (response.code() != 200) {
                throw SonarLintWsClient.handleError(response);
            }
            InputStream input = response.contentStream();
            Parser<ScannerInput.ServerIssue> parser = ScannerInput.ServerIssue.parser();
            List<ScannerInput.ServerIssue> list = ProtobufUtil.readMessages(input, parser);
            return list;
        }
    }

    private static String getIssuesUrl(String key) {
        return "/batch/issues?key=" + StringUtils.urlEncode(key);
    }
}

