/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.objectstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.ObjectStore;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.PathMapper;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Reader;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Writer;

public class SimpleObjectStore<K, V>
implements ObjectStore<K, V> {
    private final PathMapper<K> pathMapper;
    private final Reader<V> reader;
    private final Writer<V> writer;

    public SimpleObjectStore(PathMapper<K> pathMapper, Reader<V> reader, Writer<V> writer) {
        this.pathMapper = pathMapper;
        this.reader = reader;
        this.writer = writer;
    }

    public Optional<V> read(K key) throws IOException {
        Path path = (Path)this.pathMapper.apply(key);
        if (!path.toFile().exists()) {
            return Optional.empty();
        }
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            Optional<Object> optional = Optional.of(this.reader.apply((Object)inputStream));
            return optional;
        }
    }

    public void delete(K key) throws IOException {
        Path path = (Path)this.pathMapper.apply(key);
        Files.deleteIfExists(path);
    }

    public void write(K key, V value) throws IOException {
        Path path = (Path)this.pathMapper.apply(key);
        Path parent = path.getParent();
        if (!parent.toFile().exists()) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            this.writer.accept((Object)out, value);
        }
    }
}

