/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected;

import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.System2;
import org.sonarqube.ws.Common;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.container.connected.exceptions.NotFoundException;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;
import org.sonarsource.sonarlint.core.util.ws.GetRequest;
import org.sonarsource.sonarlint.core.util.ws.HttpConnector;
import org.sonarsource.sonarlint.core.util.ws.PostRequest;
import org.sonarsource.sonarlint.core.util.ws.WsConnector;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class SonarLintWsClient {
    private static final Logger LOG = LoggerFactory.getLogger(SonarLintWsClient.class);
    public static final int PAGE_SIZE = 500;
    private final WsConnector client;
    private final String userAgent;
    private final String organizationKey;

    public SonarLintWsClient(ServerConfiguration serverConfig) {
        this.userAgent = serverConfig.getUserAgent();
        this.organizationKey = serverConfig.getOrganizationKey();
        this.client = SonarLintWsClient.buildClient(serverConfig);
    }

    private static WsConnector buildClient(ServerConfiguration serverConfig) {
        return HttpConnector.newBuilder().url(serverConfig.getUrl()).userAgent(serverConfig.getUserAgent()).credentials(serverConfig.getLogin(), serverConfig.getPassword()).proxy(serverConfig.getProxy()).proxyCredentials(serverConfig.getProxyLogin(), serverConfig.getProxyPassword()).readTimeoutMilliseconds(serverConfig.getReadTimeoutMs()).connectTimeoutMilliseconds(serverConfig.getConnectTimeoutMs()).setSSLSocketFactory(serverConfig.getSSLSocketFactory()).setTrustManager(serverConfig.getTrustManager()).build();
    }

    public WsResponse get(String path) {
        WsResponse response = this.rawGet(path);
        if (!response.isSuccessful()) {
            throw SonarLintWsClient.handleError(response);
        }
        return response;
    }

    public WsResponse post(String path) {
        WsResponse response = this.rawPost(path);
        if (!response.isSuccessful()) {
            throw SonarLintWsClient.handleError(response);
        }
        return response;
    }

    public WsResponse rawPost(String path) {
        long startTime = System2.INSTANCE.now();
        PostRequest request = new PostRequest(path);
        WsResponse response = this.client.call(request);
        long duration = System2.INSTANCE.now() - startTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} {} | time={}ms", new Object[]{request.getMethod(), response.code(), response.requestUrl(), duration});
        }
        return response;
    }

    public WsResponse rawGet(String path) {
        long startTime = System2.INSTANCE.now();
        GetRequest request = new GetRequest(path);
        WsResponse response = this.client.call(request);
        long duration = System2.INSTANCE.now() - startTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} {} | time={}ms", new Object[]{request.getMethod(), response.code(), response.requestUrl(), duration});
        }
        return response;
    }

    public static RuntimeException handleError(WsResponse toBeClosed) {
        try (WsResponse failedResponse = toBeClosed;){
            if (failedResponse.code() == 401) {
                IllegalStateException illegalStateException = new IllegalStateException("Not authorized. Please check server credentials.");
                return illegalStateException;
            }
            if (failedResponse.code() == 403) {
                IllegalStateException illegalStateException = new IllegalStateException(SonarLintWsClient.tryParseAsJsonError(failedResponse.content()));
                return illegalStateException;
            }
            if (failedResponse.code() == 404) {
                NotFoundException notFoundException = new NotFoundException(SonarLintWsClient.formatHttpFailedResponse(failedResponse, null));
                return notFoundException;
            }
            String errorMsg = null;
            if (failedResponse.hasContent()) {
                errorMsg = SonarLintWsClient.tryParseAsJsonError(failedResponse.content());
            }
            IllegalStateException illegalStateException = new IllegalStateException(SonarLintWsClient.formatHttpFailedResponse(failedResponse, errorMsg));
            return illegalStateException;
        }
    }

    private static String formatHttpFailedResponse(WsResponse failedResponse, @Nullable String errorMsg) {
        return "Error " + failedResponse.code() + " on " + failedResponse.requestUrl() + (errorMsg != null ? ": " + errorMsg : "");
    }

    private static String tryParseAsJsonError(String responseContent) {
        try {
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(responseContent).getAsJsonObject();
            JsonArray errors = obj.getAsJsonArray("errors");
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (JsonElement e : errors) {
                errorMessages.add(e.getAsJsonObject().get("msg").getAsString());
            }
            return Joiner.on(", ").join(errorMessages);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    @CheckForNull
    public String getOrganizationKey() {
        return this.organizationKey;
    }

    public static <G, F> void getPaginated(SonarLintWsClient client, String baseUrl, CheckedFunction<InputStream, G> responseParser, Function<G, Common.Paging> getPaging, Function<G, List<F>> itemExtractor, Consumer<F> itemConsumer, ProgressWrapper progress) {
        int page = 0;
        boolean stop = false;
        int loaded = 0;
        do {
            WsResponse response = client.get(baseUrl + (baseUrl.contains("?") ? "&" : "?") + "ps=" + 500 + "&p=" + ++page);
            try (InputStream stream = response.contentStream();){
                G protoBufResponse = responseParser.apply(stream);
                List<F> items = itemExtractor.apply(protoBufResponse);
                for (F item : items) {
                    itemConsumer.accept(item);
                    ++loaded;
                }
                boolean isEmpty = items.isEmpty();
                Common.Paging paging = getPaging.apply(protoBufResponse);
                stop = isEmpty || paging.getTotal() > 0 && page * 500 >= paging.getTotal();
                progress.setProgressAndCheckCancel("Page " + page, (float)loaded / (float)paging.getTotal());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to process paginated WS", e);
            }
        } while (!stop);
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

