/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.HashingPathMapper;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.ObjectStore;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.PathMapper;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Reader;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Writer;
import org.sonarsource.sonarlint.core.client.api.exceptions.StorageException;
import org.sonarsource.sonarlint.core.container.connected.IssueStore;
import org.sonarsource.sonarlint.core.container.connected.objectstore.SimpleObjectStore;
import org.sonarsource.sonarlint.core.container.connected.update.IssueUtils;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;

public class ServerIssueStore
implements IssueStore {
    private final ObjectStore<String, List<ScannerInput.ServerIssue>> store;

    public ServerIssueStore(Path base) {
        HashingPathMapper pathGenerator = new HashingPathMapper(base, 2);
        Reader reader = input -> ProtobufUtil.readMessages(input, ScannerInput.ServerIssue.parser());
        Writer writer = ProtobufUtil::writeMessages;
        this.store = new SimpleObjectStore<String, List<ScannerInput.ServerIssue>>((PathMapper<String>)pathGenerator, (Reader<List<ScannerInput.ServerIssue>>)reader, (Writer<List<ScannerInput.ServerIssue>>)writer);
    }

    @Override
    public synchronized void save(List<ScannerInput.ServerIssue> issues) {
        Map<String, List<ScannerInput.ServerIssue>> issuesPerFile = issues.stream().collect(Collectors.groupingBy(IssueUtils::createFileKey));
        for (Map.Entry<String, List<ScannerInput.ServerIssue>> entry : issuesPerFile.entrySet()) {
            try {
                this.store.write((Object)entry.getKey(), entry.getValue());
            }
            catch (IOException e) {
                throw new StorageException("failed to save issues for fileKey = " + entry.getKey(), (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void delete(String fileKey) {
        try {
            this.store.delete((Object)fileKey);
        }
        catch (IOException e) {
            throw new StorageException("failed to delete issues for fileKey = " + fileKey, (Throwable)e);
        }
    }

    @Override
    public synchronized List<ScannerInput.ServerIssue> load(String fileKey) {
        try {
            Optional issues = this.store.read((Object)fileKey);
            if (issues.isPresent()) {
                return (List)issues.get();
            }
        }
        catch (IOException e) {
            throw new StorageException("failed to load issues for fileKey = " + fileKey, (Throwable)e);
        }
        return Collections.emptyList();
    }
}

