/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.Server;

public class DefaultServer
extends Server {
    private Settings settings;
    private SonarRuntime runtime;

    public DefaultServer(Settings settings, SonarRuntime runtime) {
        this.settings = settings;
        this.runtime = runtime;
    }

    @Override
    public String getId() {
        return this.settings.getString("sonar.core.id");
    }

    @Override
    public String getVersion() {
        return this.runtime.getApiVersion().toString();
    }

    @Override
    public Date getStartedAt() {
        String dateString = this.settings.getString("sonar.core.startTime");
        if (dateString != null) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(dateString);
            }
            catch (ParseException e) {
                LoggerFactory.getLogger(this.getClass()).error("The property sonar.core.startTime is badly formatted.", e);
            }
        }
        return null;
    }

    @Override
    public File getRootDir() {
        return null;
    }

    @Override
    public String getContextPath() {
        return null;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public boolean isSecured() {
        return false;
    }

    @Override
    public boolean isDev() {
        return false;
    }

    @Override
    public String getPublicRootUrl() {
        return null;
    }

    @Override
    public String getPermanentServerId() {
        return this.settings.getString("sonar.server_id");
    }
}

