/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.Metadata;
import org.sonar.api.utils.PathUtils;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.FileMetadata;

public class SonarLintInputFile
extends DefaultInputFile {
    private final ClientInputFile clientInputFile;
    private String language;
    private InputFile.Type type;

    public SonarLintInputFile(ClientInputFile clientInputFile) {
        super(new DefaultIndexedFile("sonarlint", Paths.get(clientInputFile.getPath(), new String[0]), clientInputFile.getPath(), clientInputFile.language()), null);
        this.clientInputFile = clientInputFile;
    }

    public ClientInputFile getClientInputFile() {
        return this.clientInputFile;
    }

    @Override
    public String relativePath() {
        return this.absolutePath();
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setType(InputFile.Type type) {
        this.type = type;
    }

    @Override
    @CheckForNull
    public String language() {
        return this.language;
    }

    @Override
    public InputFile.Type type() {
        return this.type;
    }

    @Override
    public String absolutePath() {
        return PathUtils.sanitize(this.path().toString());
    }

    @Override
    public File file() {
        return this.path().toFile();
    }

    @Override
    public Path path() {
        return Paths.get(this.clientInputFile.getPath(), new String[0]);
    }

    @Override
    public InputStream inputStream() throws IOException {
        return this.clientInputFile.inputStream();
    }

    @Override
    public String contents() throws IOException {
        return this.clientInputFile.contents();
    }

    @Override
    public InputFile.Status status() {
        return InputFile.Status.ADDED;
    }

    @Override
    public String key() {
        return this.absolutePath();
    }

    @Override
    public String moduleKey() {
        throw SonarLintInputFile.unsupported();
    }

    @Override
    public URI uri() {
        return this.clientInputFile.uri();
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Unsupported in SonarLint");
    }

    @Override
    public Charset charset() {
        Charset charset = this.clientInputFile.getCharset();
        return charset != null ? charset : Charset.defaultCharset();
    }

    public SonarLintInputFile init(FileMetadata.Metadata metadata) {
        this.setMetadata(new Metadata(metadata.lines, metadata.lines, "", metadata.originalLineOffsets, metadata.lastValidOffset));
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SonarLintInputFile)) {
            return false;
        }
        SonarLintInputFile that = (SonarLintInputFile)o;
        return this.path().equals(that.path());
    }

    @Override
    public int hashCode() {
        return this.path().hashCode();
    }

    @Override
    public String toString() {
        return "[path=" + this.path() + "]";
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

