/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import java.io.File;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.DefaultFilePredicates;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.FileIndexer;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.InputPathCache;

public class SonarLintFileSystem
extends DefaultFileSystem {
    private FileIndexer indexer;
    private final DefaultFilePredicates filePredicates;
    private final InputPathCache moduleInputFileCache;

    public SonarLintFileSystem(StandaloneAnalysisConfiguration analysisConfiguration, InputPathCache moduleInputFileCache, FileIndexer indexer) {
        super(analysisConfiguration.baseDir(), moduleInputFileCache);
        this.moduleInputFileCache = moduleInputFileCache;
        this.indexer = indexer;
        this.filePredicates = new DefaultFilePredicates();
        this.setWorkDir(analysisConfiguration.workDir());
    }

    public void index() {
        this.indexer.index(this);
    }

    @Override
    public InputDir inputDir(File dir) {
        return this.moduleInputFileCache.inputDir(dir.toPath());
    }

    @Override
    public FilePredicates predicates() {
        return this.filePredicates;
    }
}

