/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import com.google.common.base.Joiner;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.MessageException;
import org.sonarsource.sonarlint.core.container.analysis.SonarLintPathPattern;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.Language;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.LanguagesRepository;

public class LanguageDetection {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageDetection.class);
    private final Map<String, SonarLintPathPattern[]> patternsByLanguage = new LinkedHashMap<String, SonarLintPathPattern[]>();
    private final List<String> languagesToConsider = new ArrayList<String>();

    public LanguageDetection(LanguagesRepository languages) {
        for (Language language : languages.all()) {
            String[] patterns = language.fileSuffixes().toArray(new String[language.fileSuffixes().size()]);
            for (int i = 0; i < patterns.length; ++i) {
                String suffix = patterns[i];
                String extension = LanguageDetection.sanitizeExtension(suffix);
                patterns[i] = "**/*." + extension;
            }
            SonarLintPathPattern[] defaultLanguagePatterns = SonarLintPathPattern.create(patterns);
            this.patternsByLanguage.put(language.key(), defaultLanguagePatterns);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Declared extensions of language {} were converted to {}", (Object)language, (Object)this.getDetails(language.key()));
        }
        this.languagesToConsider.addAll(this.patternsByLanguage.keySet());
    }

    Map<String, SonarLintPathPattern[]> patternsByLanguage() {
        return this.patternsByLanguage;
    }

    @CheckForNull
    String language(InputFile inputFile) {
        String detectedLanguage = null;
        for (String languageKey : this.languagesToConsider) {
            if (!this.isCandidateForLanguage(inputFile, languageKey)) continue;
            if (detectedLanguage == null) {
                detectedLanguage = languageKey;
                continue;
            }
            throw MessageException.of(MessageFormat.format("Language of file ''{0}'' can not be decided as the file matches patterns of both {1} and {2}", inputFile.uri(), this.getDetails(detectedLanguage), this.getDetails(languageKey)));
        }
        if (detectedLanguage != null) {
            LOG.debug("Language of file '{}' is detected to be '{}'", (Object)inputFile.uri(), (Object)detectedLanguage);
            return detectedLanguage;
        }
        return null;
    }

    private boolean isCandidateForLanguage(InputFile inputFile, String languageKey) {
        SonarLintPathPattern[] patterns = this.patternsByLanguage.get(languageKey);
        if (patterns != null) {
            for (SonarLintPathPattern pathPattern : patterns) {
                if (!pathPattern.match(inputFile, false)) continue;
                return true;
            }
        }
        return false;
    }

    private String getDetails(String detectedLanguage) {
        return detectedLanguage + ": " + Joiner.on(",").join(this.patternsByLanguage.get(detectedLanguage));
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase(StringUtils.removeStart(suffix, "."));
    }
}

