/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.FileExtensionPredicate;
import org.sonar.api.batch.fs.internal.FilenamePredicate;
import org.sonarsource.sonarlint.core.container.analysis.SonarLintPathPattern;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.AbsolutePathPredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.AndPredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.FalsePredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.LanguagePredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.NotPredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.OrPredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.PathPatternPredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.RelativePathPredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.StatusPredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.TruePredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.TypePredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.URIPredicate;

public class DefaultFilePredicates
implements FilePredicates {
    @Override
    public FilePredicate all() {
        return TruePredicate.TRUE;
    }

    @Override
    public FilePredicate none() {
        return FalsePredicate.FALSE;
    }

    @Override
    public FilePredicate hasAbsolutePath(String s) {
        return new AbsolutePathPredicate(s);
    }

    @Override
    public FilePredicate hasRelativePath(String s) {
        return new RelativePathPredicate(s);
    }

    @Override
    public FilePredicate hasURI(URI uri) {
        return new URIPredicate(uri);
    }

    @Override
    public FilePredicate matchesPathPattern(String inclusionPattern) {
        return new PathPatternPredicate(new SonarLintPathPattern(inclusionPattern));
    }

    @Override
    public FilePredicate matchesPathPatterns(String[] inclusionPatterns) {
        if (inclusionPatterns.length == 0) {
            return TruePredicate.TRUE;
        }
        FilePredicate[] predicates = new FilePredicate[inclusionPatterns.length];
        for (int i = 0; i < inclusionPatterns.length; ++i) {
            predicates[i] = new PathPatternPredicate(new SonarLintPathPattern(inclusionPatterns[i]));
        }
        return this.or(predicates);
    }

    @Override
    public FilePredicate doesNotMatchPathPattern(String exclusionPattern) {
        return this.not(this.matchesPathPattern(exclusionPattern));
    }

    @Override
    public FilePredicate doesNotMatchPathPatterns(String[] exclusionPatterns) {
        if (exclusionPatterns.length == 0) {
            return TruePredicate.TRUE;
        }
        return this.not(this.matchesPathPatterns(exclusionPatterns));
    }

    @Override
    public FilePredicate hasPath(String s) {
        File file = new File(s);
        if (file.isAbsolute()) {
            return this.hasAbsolutePath(s);
        }
        return this.hasRelativePath(s);
    }

    @Override
    public FilePredicate is(File ioFile) {
        if (ioFile.isAbsolute()) {
            return this.hasAbsolutePath(ioFile.getAbsolutePath());
        }
        return this.hasRelativePath(ioFile.getPath());
    }

    @Override
    public FilePredicate hasLanguage(String language) {
        return new LanguagePredicate(language);
    }

    @Override
    public FilePredicate hasLanguages(Collection<String> languages) {
        ArrayList<FilePredicate> list = new ArrayList<FilePredicate>();
        for (String language : languages) {
            list.add(this.hasLanguage(language));
        }
        return this.or(list);
    }

    @Override
    public FilePredicate hasLanguages(String ... languages) {
        ArrayList<FilePredicate> list = new ArrayList<FilePredicate>();
        for (String language : languages) {
            list.add(this.hasLanguage(language));
        }
        return this.or(list);
    }

    @Override
    public FilePredicate hasType(InputFile.Type type) {
        return new TypePredicate(type);
    }

    @Override
    public FilePredicate not(FilePredicate p) {
        return new NotPredicate(p);
    }

    @Override
    public FilePredicate or(Collection<FilePredicate> or) {
        return OrPredicate.create(or);
    }

    @Override
    public FilePredicate or(FilePredicate ... or) {
        return OrPredicate.create(Arrays.asList(or));
    }

    @Override
    public FilePredicate or(FilePredicate first, FilePredicate second) {
        return OrPredicate.create(Arrays.asList(first, second));
    }

    @Override
    public FilePredicate and(Collection<FilePredicate> and) {
        return AndPredicate.create(and);
    }

    @Override
    public FilePredicate and(FilePredicate ... and) {
        return AndPredicate.create(Arrays.asList(and));
    }

    @Override
    public FilePredicate and(FilePredicate first, FilePredicate second) {
        return AndPredicate.create(Arrays.asList(first, second));
    }

    @Override
    public FilePredicate hasFilename(String s) {
        return new FilenamePredicate(s);
    }

    @Override
    public FilePredicate hasExtension(String s) {
        return new FileExtensionPredicate(s);
    }

    @Override
    public FilePredicate hasStatus(InputFile.Status status) {
        return new StatusPredicate(status);
    }

    @Override
    public FilePredicate hasAnyStatus() {
        return new StatusPredicate(null);
    }
}

