/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.PathUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class SonarLintPathPattern {
    private static final Logger LOG = Loggers.get(SonarLintPathPattern.class);
    final WildcardPattern pattern;

    public SonarLintPathPattern(String pattern) {
        if (pattern.startsWith("file:")) {
            LOG.warn("Unsupported path pattern: " + pattern);
            pattern = pattern.replaceAll("^file:/*", "");
        }
        if (!pattern.startsWith("**/")) {
            pattern = "**/" + pattern;
        }
        this.pattern = WildcardPattern.create(pattern);
    }

    public static SonarLintPathPattern[] create(String[] s) {
        SonarLintPathPattern[] result = new SonarLintPathPattern[s.length];
        for (int i = 0; i < s.length; ++i) {
            result[i] = new SonarLintPathPattern(s[i]);
        }
        return result;
    }

    public boolean match(InputFile inputFile) {
        return this.match(inputFile, true);
    }

    public boolean match(InputFile inputFile, boolean caseSensitiveFileExtension) {
        String extension;
        String path = PathUtils.sanitize(inputFile.uri().getPath());
        if (!caseSensitiveFileExtension && StringUtils.isNotBlank(extension = SonarLintPathPattern.sanitizeExtension(FilenameUtils.getExtension(path)))) {
            path = StringUtils.removeEndIgnoreCase(path, extension);
            path = path + extension;
        }
        return path != null && this.pattern.match(path);
    }

    public String toString() {
        return this.pattern.toString();
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase(StringUtils.removeStart(suffix, "."));
    }
}

