/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.internal.MapSettings;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class ServerConfigurationProvider {
    private Configuration serverConfig;

    public ServerConfigurationProvider(StorageReader storage, StandaloneAnalysisConfiguration config, PropertyDefinitions propertyDefinitions) {
        this.serverConfig = new ServerConfiguration(storage, config, propertyDefinitions).asConfig();
    }

    public ServerConfigurationProvider(StandaloneAnalysisConfiguration config, PropertyDefinitions propertyDefinitions) {
        this.serverConfig = new ServerConfiguration(null, config, propertyDefinitions).asConfig();
    }

    public Configuration getServerConfig() {
        return this.serverConfig;
    }

    public static class ServerConfiguration
    extends MapSettings {
        private final Map<String, String> properties = new HashMap<String, String>();

        private ServerConfiguration(@Nullable StorageReader storage, StandaloneAnalysisConfiguration config, PropertyDefinitions propertyDefinitions) {
            super(propertyDefinitions);
            if (storage != null) {
                Sonarlint.GlobalProperties globalProps = storage.readGlobalProperties();
                this.addProperties(globalProps.getPropertiesMap());
                if (config instanceof ConnectedAnalysisConfiguration && ((ConnectedAnalysisConfiguration)config).moduleKey() != null) {
                    Sonarlint.ModuleConfiguration projectConfig = storage.readModuleConfig(((ConnectedAnalysisConfiguration)config).moduleKey());
                    this.addProperties(projectConfig.getPropertiesMap());
                }
            }
        }

        @Override
        protected Optional<String> get(String key) {
            return Optional.ofNullable(this.properties.get(key));
        }

        @Override
        protected void set(String key, String value) {
            this.properties.put(key, value);
        }

        @Override
        protected void remove(String key) {
            this.properties.remove(key);
        }

        @Override
        public Map<String, String> getProperties() {
            return this.properties;
        }
    }
}

