/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis;

import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.scan.filesystem.FileExclusions;
import org.sonarsource.sonarlint.core.container.analysis.ServerConfigurationProvider;
import org.sonarsource.sonarlint.core.container.analysis.SonarLintPathPattern;

public class ExclusionFilters {
    private static final Logger LOG = LoggerFactory.getLogger(ExclusionFilters.class);
    private final FileExclusions exclusionSettings;
    private SonarLintPathPattern[] mainInclusions;
    private SonarLintPathPattern[] mainExclusions;
    private SonarLintPathPattern[] testInclusions;
    private SonarLintPathPattern[] testExclusions;

    public ExclusionFilters(ServerConfigurationProvider serverConfigProvider) {
        this.exclusionSettings = new FileExclusions(serverConfigProvider.getServerConfig());
    }

    public void prepare() {
        this.mainInclusions = this.prepareMainInclusions();
        this.mainExclusions = this.prepareMainExclusions();
        this.testInclusions = this.prepareTestInclusions();
        this.testExclusions = this.prepareTestExclusions();
        ExclusionFilters.log("Included sources: ", this.mainInclusions);
        ExclusionFilters.log("Excluded sources: ", this.mainExclusions);
        ExclusionFilters.log("Included tests: ", this.testInclusions);
        ExclusionFilters.log("Excluded tests: ", this.testExclusions);
    }

    private static void log(String title, SonarLintPathPattern[] patterns) {
        if (patterns.length > 0) {
            LOG.debug(title);
            for (SonarLintPathPattern pattern : patterns) {
                LOG.debug("  {}", (Object)pattern);
            }
        }
    }

    public boolean accept(InputFile inputFile, InputFile.Type type) {
        SonarLintPathPattern[] exclusionPatterns;
        SonarLintPathPattern[] inclusionPatterns;
        if (InputFile.Type.MAIN == type) {
            inclusionPatterns = this.mainInclusions;
            exclusionPatterns = this.mainExclusions;
        } else if (InputFile.Type.TEST == type) {
            inclusionPatterns = this.testInclusions;
            exclusionPatterns = this.testExclusions;
        } else {
            throw new IllegalArgumentException("Unknown file type: " + (Object)((Object)type));
        }
        if (inclusionPatterns.length > 0) {
            boolean matchInclusion = false;
            SonarLintPathPattern[] sonarLintPathPatternArray = inclusionPatterns;
            int n = sonarLintPathPatternArray.length;
            for (int i = 0; i < n; ++i) {
                SonarLintPathPattern pattern = sonarLintPathPatternArray[i];
                matchInclusion |= pattern.match(inputFile);
            }
            if (!matchInclusion) {
                return false;
            }
        }
        if (exclusionPatterns.length > 0) {
            for (SonarLintPathPattern pattern : exclusionPatterns) {
                if (!pattern.match(inputFile)) continue;
                return false;
            }
        }
        return true;
    }

    SonarLintPathPattern[] prepareMainInclusions() {
        if (this.exclusionSettings.sourceInclusions().length > 0) {
            return SonarLintPathPattern.create(this.exclusionSettings.sourceInclusions());
        }
        return new SonarLintPathPattern[0];
    }

    SonarLintPathPattern[] prepareTestInclusions() {
        return SonarLintPathPattern.create(this.computeTestInclusions());
    }

    private String[] computeTestInclusions() {
        if (this.exclusionSettings.testInclusions().length > 0) {
            return this.exclusionSettings.testInclusions();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    SonarLintPathPattern[] prepareMainExclusions() {
        String[] patterns = (String[])ArrayUtils.addAll(this.exclusionSettings.sourceExclusions(), this.computeTestInclusions());
        return SonarLintPathPattern.create(patterns);
    }

    SonarLintPathPattern[] prepareTestExclusions() {
        return SonarLintPathPattern.create(this.exclusionSettings.testExclusions());
    }
}

