/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.container.Uuids;

class ComponentKeys {
    private static final Pattern IDENTITY_HASH_PATTERN = Pattern.compile(".+@[a-f0-9]+");
    private final Set<Class> objectsWithoutToString = new HashSet<Class>();

    ComponentKeys() {
    }

    Object of(Object component) {
        return this.of(component, Loggers.get(ComponentKeys.class));
    }

    Object of(Object component, Logger log) {
        if (component instanceof Class) {
            return component;
        }
        String key = component.toString();
        if (IDENTITY_HASH_PATTERN.matcher(key).matches()) {
            if (!this.objectsWithoutToString.add(component.getClass())) {
                log.warn(String.format("Bad component key: %s. Please implement toString() method on class %s", key, component.getClass().getName()));
            }
            key = key + Uuids.createFast();
        }
        return component.getClass().getCanonicalName() + "-" + key;
    }
}

