/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.sensor;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.internal.DefaultSensorDescriptor;
import org.sonarsource.sonarlint.core.analyzer.sensor.DefaultSensorContext;
import org.sonarsource.sonarlint.core.analyzer.sensor.ScannerExtensionDictionnary;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorOptimizer;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorsExecutor;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;
import org.sonarsource.sonarlint.core.util.StringUtils;

public class NewSensorsExecutor
implements SensorsExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(NewSensorsExecutor.class);
    private final SensorOptimizer sensorOptimizer;
    private final ProgressWrapper progress;
    private final Sensor[] sensors;
    private final DefaultSensorContext context;

    public NewSensorsExecutor(DefaultSensorContext context, SensorOptimizer sensorOptimizer, ProgressWrapper progress) {
        this(context, sensorOptimizer, progress, new Sensor[0]);
    }

    public NewSensorsExecutor(DefaultSensorContext context, SensorOptimizer sensorOptimizer, ProgressWrapper progress, Sensor[] sensors) {
        this.context = context;
        this.sensors = sensors;
        this.sensorOptimizer = sensorOptimizer;
        this.progress = progress;
    }

    @Override
    public void execute() {
        for (Sensor sensor : ScannerExtensionDictionnary.sort(Arrays.asList(this.sensors))) {
            this.progress.checkCancel();
            DefaultSensorDescriptor descriptor = new DefaultSensorDescriptor();
            sensor.describe(descriptor);
            if (!this.sensorOptimizer.shouldExecute(descriptor)) continue;
            NewSensorsExecutor.executeSensor(this.context, sensor, descriptor);
        }
    }

    private static void executeSensor(SensorContext context, Sensor sensor, DefaultSensorDescriptor descriptor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Execute Sensor: {}", (Object)(descriptor.name() != null ? descriptor.name() : StringUtils.describe(sensor)));
        }
        sensor.execute(context);
    }
}

