/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.issue;

import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.issue.batch.IssueFilter;
import org.sonar.api.resources.Project;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.core.analyzer.issue.DefaultClientIssue;
import org.sonarsource.sonarlint.core.analyzer.issue.DefaultFilterableIssue;
import org.sonarsource.sonarlint.core.analyzer.issue.DefaultIssueFilterChain;
import org.sonarsource.sonarlint.core.analyzer.issue.DeprecatedIssueAdapterForFilter;
import org.sonarsource.sonarlint.core.analyzer.issue.DeprecatedIssueFilterChain;

@SonarLintSide
public class IssueFilters {
    private final org.sonar.api.scan.issue.filter.IssueFilter[] filters;
    private final IssueFilter[] deprecatedFilters;
    private final Project project;

    public IssueFilters(Project project, org.sonar.api.scan.issue.filter.IssueFilter[] exclusionFilters, IssueFilter[] filters) {
        this.project = project;
        this.filters = exclusionFilters;
        this.deprecatedFilters = filters;
    }

    public IssueFilters(Project project, org.sonar.api.scan.issue.filter.IssueFilter[] filters) {
        this(project, filters, new IssueFilter[0]);
    }

    public IssueFilters(Project project, IssueFilter[] deprecatedFilters) {
        this(project, new org.sonar.api.scan.issue.filter.IssueFilter[0], deprecatedFilters);
    }

    public IssueFilters(Project project) {
        this(project, new org.sonar.api.scan.issue.filter.IssueFilter[0], new IssueFilter[0]);
    }

    public boolean accept(InputComponent inputComponent, DefaultClientIssue rawIssue) {
        DefaultIssueFilterChain filterChain = new DefaultIssueFilterChain(this.filters);
        DefaultFilterableIssue fIssue = new DefaultFilterableIssue(this.project, rawIssue, inputComponent);
        if (filterChain.accept(fIssue)) {
            return this.acceptDeprecated(inputComponent.key(), rawIssue);
        }
        return false;
    }

    public boolean acceptDeprecated(String componentKey, DefaultClientIssue rawIssue) {
        DeprecatedIssueAdapterForFilter issue = new DeprecatedIssueAdapterForFilter(this.project, rawIssue, componentKey);
        return new DeprecatedIssueFilterChain(this.deprecatedFilters).accept(issue);
    }
}

