/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.issue;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;

public class DefaultIssueFilterChain
implements IssueFilterChain {
    private final List<IssueFilter> filters;

    public DefaultIssueFilterChain(IssueFilter ... filters) {
        this.filters = ImmutableList.copyOf(filters);
    }

    public DefaultIssueFilterChain() {
        this.filters = ImmutableList.of();
    }

    private DefaultIssueFilterChain(List<IssueFilter> filters) {
        this.filters = filters;
    }

    @Override
    public boolean accept(FilterableIssue issue) {
        if (this.filters.isEmpty()) {
            return true;
        }
        return this.filters.get(0).accept(issue, new DefaultIssueFilterChain(this.filters.subList(1, this.filters.size())));
    }
}

