/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.collect.ArrayListMultimap;
import org.sonar.api.internal.google.common.collect.ImmutableListMultimap;
import org.sonar.api.internal.google.common.collect.ListMultimap;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.server.ServerSide;

@ScannerSide
@ServerSide
@ComputeEngineSide
public class ResourceTypeTree {
    private final List<ResourceType> types;
    private final ListMultimap<String, String> relations;
    private final ResourceType root;

    private ResourceTypeTree(Builder builder) {
        this.types = Collections.unmodifiableList(new ArrayList(builder.types));
        this.relations = ImmutableListMultimap.copyOf(builder.relations);
        this.root = builder.root;
    }

    public List<ResourceType> getTypes() {
        return this.types;
    }

    public List<String> getChildren(String qualifier) {
        return this.relations.get(qualifier);
    }

    public ResourceType getRootType() {
        return this.root;
    }

    public List<String> getLeaves() {
        return Collections.unmodifiableList(this.relations.values().stream().filter(qualifier -> this.relations.get((String)qualifier).isEmpty()).collect(Collectors.toList()));
    }

    public String toString() {
        return this.root.getQualifier();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ResourceType> types = new ArrayList<ResourceType>();
        private ListMultimap<String, String> relations = ArrayListMultimap.create();
        private ResourceType root;

        private Builder() {
        }

        public Builder addType(ResourceType type) {
            Objects.requireNonNull(type);
            Preconditions.checkArgument(!this.types.contains(type), String.format("%s is already registered", type.getQualifier()));
            this.types.add(type);
            return this;
        }

        public Builder addRelations(String parentQualifier, String ... childrenQualifiers) {
            Objects.requireNonNull(parentQualifier);
            Objects.requireNonNull(childrenQualifiers);
            Preconditions.checkArgument(childrenQualifiers.length > 0, "childrenQualifiers can't be empty");
            this.relations.putAll(parentQualifier, Arrays.asList(childrenQualifiers));
            return this;
        }

        public ResourceTypeTree build() {
            Collection children = this.relations.values();
            for (ResourceType type : this.types) {
                if (children.contains(type.getQualifier())) continue;
                this.root = type;
                break;
            }
            return new ResourceTypeTree(this);
        }
    }
}

