/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.project;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;
import org.springframework.util.StringUtils;

public class DefaultProjectContributorState
implements IProjectContributorState {
    private Map<Class, Object> managedObjects = new HashMap<Class, Object>();
    private Map<Dictionary<String, String>, Object> managedObjectsWithFilters = new HashMap<Dictionary<String, String>, Object>();

    @Override
    public <T> T get(Class<T> clazz) {
        if (this.managedObjects.containsKey(clazz)) {
            return (T)this.managedObjects.get(clazz);
        }
        for (Map.Entry<Class, Object> entry : this.managedObjects.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey())) continue;
            return (T)entry.getValue();
        }
        return null;
    }

    @Override
    public boolean hold(Object obj) {
        if (this.managedObjects.containsKey(obj.getClass())) {
            return false;
        }
        this.managedObjects.put(obj.getClass(), obj);
        return true;
    }

    @Override
    public <T> T get(Class<T> clazz, String filterText) {
        if (!StringUtils.hasLength((String)filterText)) {
            return null;
        }
        try {
            Filter filter = FrameworkUtil.createFilter((String)filterText);
            for (Map.Entry<Dictionary<String, String>, Object> entry : this.managedObjectsWithFilters.entrySet()) {
                if (!filter.match(entry.getKey())) continue;
                return (T)entry.getValue();
            }
        }
        catch (InvalidSyntaxException e) {
            SpringCore.log(e);
        }
        return null;
    }

    @Override
    public boolean hold(Object obj, Dictionary<String, String> attibutes) {
        if (this.managedObjectsWithFilters.containsKey(attibutes)) {
            return false;
        }
        this.managedObjectsWithFilters.put(attibutes, obj);
        return true;
    }
}

