/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.typehierarchy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElement;

public class ClasspathElementJar
implements ClasspathElement {
    private JarFile jarFile;
    private String jarFileName;
    private Set<String> knownPackageNames;
    private long lastModified;
    private static Map<String, PackageCacheEntry> PackageCache = new ConcurrentHashMap<String, PackageCacheEntry>();

    public ClasspathElementJar(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    @Override
    public InputStream getStream(String fullyQualifiedClassFileName, String packageName, String classFileName) throws Exception {
        if (!this.isPackage(packageName)) {
            return null;
        }
        ZipEntry entry = this.jarFile.getEntry(fullyQualifiedClassFileName);
        if (entry != null) {
            return this.jarFile.getInputStream(entry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        ClasspathElementJar classpathElementJar = this;
        synchronized (classpathElementJar) {
            if (this.jarFile != null) {
                try {
                    this.jarFile.close();
                }
                catch (IOException iOException) {}
                this.jarFile = null;
            }
            this.knownPackageNames = null;
        }
    }

    public long lastModified() {
        if (this.lastModified == 0L) {
            this.lastModified = new File(this.jarFile.getName()).lastModified();
        }
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPackage(String qualifiedPackageName) {
        if (this.knownPackageNames != null) {
            return this.knownPackageNames.contains(qualifiedPackageName);
        }
        try {
            ClasspathElementJar classpathElementJar = this;
            synchronized (classpathElementJar) {
                if (this.jarFile == null) {
                    this.jarFile = new JarFile(this.jarFileName);
                }
                this.knownPackageNames = this.findPackageSet();
            }
        }
        catch (Exception exception) {
            this.knownPackageNames = Collections.newSetFromMap(new ConcurrentHashMap());
        }
        return this.knownPackageNames.contains(qualifiedPackageName);
    }

    private Set<String> findPackageSet() {
        long lastModified = this.lastModified();
        long fileSize = new File(this.jarFileName).length();
        PackageCacheEntry cacheEntry = PackageCache.get(this.jarFileName);
        if (cacheEntry != null && cacheEntry.lastModified == lastModified && cacheEntry.fileSize == fileSize) {
            return cacheEntry.packageSet;
        }
        Set<String> packageSet = Collections.newSetFromMap(new ConcurrentHashMap());
        packageSet.add("");
        Enumeration<JarEntry> e = this.jarFile.entries();
        block0: while (e.hasMoreElements()) {
            String fileName = ((ZipEntry)e.nextElement()).getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (!packageSet.add(packageName)) continue block0;
                last = packageName.lastIndexOf(47);
            }
        }
        PackageCache.put(this.jarFileName, new PackageCacheEntry(lastModified, fileSize, packageSet));
        return packageSet;
    }

    private static class PackageCacheEntry {
        long lastModified;
        long fileSize;
        Set<String> packageSet;

        public PackageCacheEntry(long lastModified, long fileSize, Set<String> packageSet) {
            this.lastModified = lastModified;
            this.fileSize = fileSize;
            this.packageSet = packageSet;
        }
    }
}

