/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.typehierarchy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElement;

public class ClasspathElementDirectory
implements ClasspathElement {
    private String directoryPath;
    private Map<String, String[]> directoryCache;
    private String[] missingPackageHolder;

    public ClasspathElementDirectory(File file) {
        this.directoryPath = file.getAbsolutePath();
        this.directoryCache = new ConcurrentHashMap<String, String[]>();
        this.missingPackageHolder = new String[1];
    }

    @Override
    public InputStream getStream(String fullyQualifiedClassFileName, String packageName, String classFileName) throws Exception {
        if (!this.doesFileExist(fullyQualifiedClassFileName, packageName, classFileName)) {
            return null;
        }
        try {
            return new FileInputStream(String.valueOf(this.directoryPath) + File.separatorChar + fullyQualifiedClassFileName);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void cleanup() {
        this.directoryCache.clear();
    }

    private boolean doesFileExist(String fullyQualifiedClassFileName, String packageName, String classFileName) {
        String[] dirList = this.directoryList(packageName);
        if (dirList == null) {
            return false;
        }
        int i = dirList.length;
        while (--i >= 0) {
            if (!classFileName.equals(dirList[i])) continue;
            return true;
        }
        return false;
    }

    private String[] directoryList(String qualifiedPackageName) {
        String[] dirList = this.directoryCache.get(qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        File packageDir = new File(String.valueOf(this.directoryPath) + File.separatorChar + qualifiedPackageName);
        String[] list = packageDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        });
        if (list != null) {
            this.directoryCache.put(qualifiedPackageName, list);
            return list;
        }
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }
}

