/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.classreading;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.classreading.AnnotationMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.java.classreading.JdtConnectedMetadata;
import org.springframework.ide.eclipse.core.java.classreading.JdtConnectedMethodMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;

public class JdtConnectedAnnotationMetadataReadingVisitor
extends AnnotationMetadataReadingVisitor
implements JdtConnectedMetadata {
    private final IType type;

    public JdtConnectedAnnotationMetadataReadingVisitor(ClassLoader classloader, IType type) {
        super(classloader);
        this.type = type;
    }

    @Override
    public IJavaElement getJavaElement() {
        return this.type;
    }

    @Override
    public JavaModelSourceLocation createSourceLocation() throws JavaModelException {
        return new JavaModelSourceLocation((IJavaElement)this.type);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new JdtConnectedMethodMetadataReadingVisitor(this.type, name, access, desc, this.getClassName(), this.classLoader, this.methodMetadataSet, Type.getReturnType((String)desc).getClassName());
    }

    public boolean isAnnotated(String annotationType) {
        return !ImportResource.class.getName().equals(annotationType) && super.isAnnotated(annotationType);
    }

    public AnnotationAttributes getAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        AnnotationAttributes attributes = super.getAnnotationAttributes(annotationName, classValuesAsString);
        if (attributes != null && "org.springframework.context.annotation.PropertySource".equals(annotationName)) {
            attributes.put((Object)"ignoreResourceNotFound", (Object)Boolean.TRUE);
        }
        return attributes;
    }
}

