/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeSummaryResult;
import com.collabnet.subversion.merge.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MergeSummaryWizardPage
extends WizardPage {
    private MergeOutput[] mergeOutputs;
    private String resolvedConflicts = "0";
    private String skippedFiles = "0";
    private String skippedFolders = "0";
    private String fileConflicts = "0";
    private String treeConflicts = "0";
    private String resolvedTreeConflicts = "0";
    private String propertyConflicts = "0";
    private String resolvedPropertyConflicts = "0";
    private String fileMerges = "0";
    private String propertyMerges = "0";
    private String fileUpdates = "0";
    private String propertyUpdates = "0";
    private String fileDeletes = "0";
    private String fileAdds = "0";
    private String fileExisting = "0";
    private boolean resumed = false;

    public MergeSummaryWizardPage(String pageName) {
        super(pageName, Messages.MergeSummaryWizardPage_title, Activator.getDefault().getImageDescriptor("svn_wizban.png"));
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        int resolvedConflictsTotal = 0;
        int skippedFilesTotal = 0;
        int skippedFoldersTotal = 0;
        int fileConflictsTotal = 0;
        int treeConflictsTotal = 0;
        int resolvedTreeConflictsTotal = 0;
        int propertyConflictsTotal = 0;
        int resolvedPropertyConflictsTotal = 0;
        int fileMergesTotal = 0;
        int propertyMergesTotal = 0;
        int fileUpdatesTotal = 0;
        int propertyUpdatesTotal = 0;
        int fileDeletesTotal = 0;
        int fileAddsTotal = 0;
        int fileExistingTotal = 0;
        int i = 0;
        while (i < this.mergeOutputs.length) {
            MergeSummaryResult[] mergeSummaryResults = this.mergeOutputs[i].getMergeSummaryResults();
            int j = 0;
            while (j < mergeSummaryResults.length) {
                String category = mergeSummaryResults[j].getCategory();
                int number = Integer.parseInt(mergeSummaryResults[j].getNumber());
                if (mergeSummaryResults[j].getType() == 2) {
                    if (category.startsWith("Resolved conflicts")) {
                        resolvedTreeConflictsTotal += number;
                    } else if (category.startsWith("Tree conflicts")) {
                        treeConflictsTotal += number;
                    }
                } else if (mergeSummaryResults[j].getType() == 0) {
                    if (category.startsWith("Resolved conflicts")) {
                        resolvedConflictsTotal += number;
                    } else if (category.startsWith("Skipped files")) {
                        skippedFilesTotal += number;
                    } else if (category.startsWith("Skipped folders")) {
                        skippedFoldersTotal += number;
                    } else if (category.startsWith("Conflicts")) {
                        fileConflictsTotal += number;
                    } else if (category.startsWith("Merged")) {
                        fileMergesTotal += number;
                    } else if (category.startsWith("Updated")) {
                        fileUpdatesTotal += number;
                    } else if (category.startsWith("Deleted")) {
                        fileDeletesTotal += number;
                    } else if (category.startsWith("Added")) {
                        fileAddsTotal += number;
                    } else if (category.startsWith("Existing")) {
                        fileExistingTotal += number;
                    }
                } else if (category.startsWith("Conflicts")) {
                    propertyConflictsTotal += number;
                } else if (category.startsWith("Resolved conflicts")) {
                    resolvedPropertyConflictsTotal += number;
                } else if (category.startsWith("Merged")) {
                    propertyMergesTotal += number;
                } else if (category.startsWith("Updated")) {
                    propertyUpdatesTotal += number;
                }
                ++j;
            }
            ++i;
        }
        this.resolvedConflicts = Integer.toString(resolvedConflictsTotal);
        this.resolvedPropertyConflicts = Integer.toString(resolvedPropertyConflictsTotal);
        this.skippedFiles = Integer.toString(skippedFilesTotal);
        this.skippedFolders = Integer.toString(skippedFoldersTotal);
        this.fileConflicts = Integer.toString(fileConflictsTotal);
        this.treeConflicts = Integer.toString(treeConflictsTotal);
        this.resolvedTreeConflicts = Integer.toString(resolvedTreeConflictsTotal);
        this.propertyConflicts = Integer.toString(propertyConflictsTotal);
        this.fileMerges = Integer.toString(fileMergesTotal);
        this.propertyMerges = Integer.toString(propertyMergesTotal);
        this.fileUpdates = Integer.toString(fileUpdatesTotal);
        this.propertyUpdates = Integer.toString(propertyUpdatesTotal);
        this.fileDeletes = Integer.toString(fileDeletesTotal);
        this.fileAdds = Integer.toString(fileAddsTotal);
        this.fileExisting = Integer.toString(fileExistingTotal);
        if (this.resumed) {
            Label label = new Label(composite, 64);
            label.setText(Messages.MergeSummaryWizardPage_note);
            data = new GridData();
            data.widthHint = 500;
            label.setLayoutData((Object)data);
            new Label(composite, 0);
        }
        Group fileGroup = new Group(composite, 0);
        fileGroup.setText(Messages.MergeSummaryWizardPage_fileStatistics);
        GridLayout fileLayout = new GridLayout();
        fileLayout.numColumns = 2;
        fileGroup.setLayout((Layout)fileLayout);
        data = new GridData(1808);
        fileGroup.setLayoutData((Object)data);
        Label fileUpdateLabel = new Label((Composite)fileGroup, 0);
        fileUpdateLabel.setText(Messages.MergeSummaryWizardPage_updated);
        data = new GridData();
        data.horizontalAlignment = 3;
        fileUpdateLabel.setLayoutData((Object)data);
        Text fileUpdateText = new Text((Composite)fileGroup, 0);
        fileUpdateText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        fileUpdateText.setLayoutData((Object)data);
        fileUpdateText.setText(this.fileUpdates);
        Label fileAddLabel = new Label((Composite)fileGroup, 0);
        fileAddLabel.setText(Messages.MergeSummaryWizardPage_added);
        data = new GridData();
        data.horizontalAlignment = 3;
        fileAddLabel.setLayoutData((Object)data);
        Text fileAddText = new Text((Composite)fileGroup, 0);
        fileAddText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        fileAddText.setLayoutData((Object)data);
        fileAddText.setText(this.fileAdds);
        Label fileExistingLabel = new Label((Composite)fileGroup, 0);
        fileExistingLabel.setText(Messages.MergeSummaryWizardPage_existing);
        data = new GridData();
        data.horizontalAlignment = 3;
        fileExistingLabel.setLayoutData((Object)data);
        Text fileExistingText = new Text((Composite)fileGroup, 0);
        fileExistingText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        fileExistingText.setLayoutData((Object)data);
        fileExistingText.setText(this.fileExisting);
        Label fileDeleteLabel = new Label((Composite)fileGroup, 0);
        fileDeleteLabel.setText(Messages.MergeSummaryWizardPage_deleted);
        data = new GridData();
        data.horizontalAlignment = 3;
        fileDeleteLabel.setLayoutData((Object)data);
        Text fileDeleteText = new Text((Composite)fileGroup, 0);
        fileDeleteText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        fileDeleteText.setLayoutData((Object)data);
        fileDeleteText.setText(this.fileDeletes);
        Label fileMergeLabel = new Label((Composite)fileGroup, 0);
        fileMergeLabel.setText(Messages.MergeSummaryWizardPage_merged);
        data = new GridData();
        data.horizontalAlignment = 3;
        fileMergeLabel.setLayoutData((Object)data);
        Text fileMergeText = new Text((Composite)fileGroup, 0);
        fileMergeText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        fileMergeText.setLayoutData((Object)data);
        fileMergeText.setText(this.fileMerges);
        Label fileConflictLabel = new Label((Composite)fileGroup, 0);
        fileConflictLabel.setText(Messages.MergeSummaryWizardPage_conflicts);
        data = new GridData();
        data.horizontalAlignment = 3;
        fileConflictLabel.setLayoutData((Object)data);
        Text fileConflictText = new Text((Composite)fileGroup, 0);
        fileConflictText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        fileConflictText.setLayoutData((Object)data);
        fileConflictText.setText(this.fileConflicts);
        Label fileResolvedLabel = new Label((Composite)fileGroup, 0);
        fileResolvedLabel.setText(Messages.MergeSummaryWizardPage_resolvedConflicts);
        data = new GridData();
        data.horizontalAlignment = 3;
        fileResolvedLabel.setLayoutData((Object)data);
        Text fileResolvedText = new Text((Composite)fileGroup, 0);
        fileResolvedText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        fileResolvedText.setLayoutData((Object)data);
        fileResolvedText.setText(this.resolvedConflicts);
        Label skippedFilesLabel = new Label((Composite)fileGroup, 0);
        skippedFilesLabel.setText(Messages.MergeSummaryWizardPage_skippedFiles);
        data = new GridData();
        data.horizontalAlignment = 3;
        skippedFilesLabel.setLayoutData((Object)data);
        Text skippedFilesText = new Text((Composite)fileGroup, 0);
        skippedFilesText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        skippedFilesText.setLayoutData((Object)data);
        skippedFilesText.setText(this.skippedFiles);
        Label skippedFoldersLabel = new Label((Composite)fileGroup, 0);
        skippedFoldersLabel.setText(Messages.MergeSummaryWizardPage_skippedFolders);
        data = new GridData();
        data.horizontalAlignment = 3;
        skippedFoldersLabel.setLayoutData((Object)data);
        Text skippedFoldersText = new Text((Composite)fileGroup, 0);
        skippedFoldersText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        skippedFoldersText.setLayoutData((Object)data);
        skippedFoldersText.setText(this.skippedFolders);
        Group propertyGroup = new Group(composite, 0);
        propertyGroup.setText(Messages.MergeSummaryWizardPage_propertyStatistics);
        GridLayout propertyLayout = new GridLayout();
        propertyLayout.numColumns = 2;
        propertyGroup.setLayout((Layout)propertyLayout);
        data = new GridData(1808);
        propertyGroup.setLayoutData((Object)data);
        Label propertyUpdateLabel = new Label((Composite)propertyGroup, 0);
        propertyUpdateLabel.setText(Messages.MergeSummaryWizardPage_updated);
        data = new GridData();
        data.horizontalAlignment = 3;
        propertyUpdateLabel.setLayoutData((Object)data);
        Text propertyUpdateText = new Text((Composite)propertyGroup, 0);
        propertyUpdateText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        propertyUpdateText.setLayoutData((Object)data);
        propertyUpdateText.setText(this.propertyUpdates);
        Label propertyMergeLabel = new Label((Composite)propertyGroup, 0);
        propertyMergeLabel.setText(Messages.MergeSummaryWizardPage_merged);
        data = new GridData();
        data.horizontalAlignment = 3;
        propertyMergeLabel.setLayoutData((Object)data);
        Text propertyMergeText = new Text((Composite)propertyGroup, 0);
        propertyMergeText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        propertyMergeText.setLayoutData((Object)data);
        propertyMergeText.setText(this.propertyMerges);
        Label propertyConflictLabel = new Label((Composite)propertyGroup, 0);
        propertyConflictLabel.setText(Messages.MergeSummaryWizardPage_conflicts);
        data = new GridData();
        data.horizontalAlignment = 3;
        propertyConflictLabel.setLayoutData((Object)data);
        Text propertyConflictText = new Text((Composite)propertyGroup, 0);
        propertyConflictText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        propertyConflictText.setLayoutData((Object)data);
        propertyConflictText.setText(this.propertyConflicts);
        Label propertyResolvedLabel = new Label((Composite)propertyGroup, 0);
        propertyResolvedLabel.setText(Messages.MergeSummaryWizardPage_resolvedConflicts);
        data = new GridData();
        data.horizontalAlignment = 3;
        propertyResolvedLabel.setLayoutData((Object)data);
        Text propertyResolvedText = new Text((Composite)propertyGroup, 0);
        propertyResolvedText.setEditable(false);
        data = new GridData();
        data.widthHint = 100;
        propertyResolvedText.setLayoutData((Object)data);
        propertyResolvedText.setText(this.resolvedPropertyConflicts);
        if (treeConflictsTotal > 0) {
            Group treeGroup = new Group(composite, 0);
            treeGroup.setText(Messages.MergeSummaryWizardPage_treeConflictStatistics);
            GridLayout treeLayout = new GridLayout();
            treeLayout.numColumns = 2;
            treeGroup.setLayout((Layout)treeLayout);
            data = new GridData(1808);
            treeGroup.setLayoutData((Object)data);
            Label treeConflictLabel = new Label((Composite)treeGroup, 0);
            treeConflictLabel.setText(Messages.MergeSummaryWizardPage_0);
            data = new GridData();
            data.horizontalAlignment = 3;
            treeConflictLabel.setLayoutData((Object)data);
            Text treeConflictText = new Text((Composite)treeGroup, 0);
            treeConflictText.setEditable(false);
            data = new GridData();
            data.widthHint = 100;
            treeConflictText.setLayoutData((Object)data);
            treeConflictText.setText(this.treeConflicts);
            Label resolvedTreeConflictLabel = new Label((Composite)treeGroup, 0);
            resolvedTreeConflictLabel.setText(Messages.MergeSummaryWizardPage_1);
            data = new GridData();
            data.horizontalAlignment = 3;
            resolvedTreeConflictLabel.setLayoutData((Object)data);
            Text resolvedTreeConflictText = new Text((Composite)treeGroup, 0);
            resolvedTreeConflictText.setEditable(false);
            data = new GridData();
            data.widthHint = 100;
            resolvedTreeConflictText.setLayoutData((Object)data);
            resolvedTreeConflictText.setText(this.resolvedTreeConflicts);
        }
        if (this.mergeOutputs.length == 1) {
            this.setMessage(String.valueOf(Messages.MergeSummaryWizardPage_messageMultiple) + this.mergeOutputs[0].getResource().getFullPath().makeRelative().toOSString());
        } else {
            this.setMessage(Messages.MergeSummaryWizardPage_message);
        }
        this.setControl((Control)outerContainer);
    }

    public void setMergeOutputs(MergeOutput[] mergeOutputs) {
        this.mergeOutputs = mergeOutputs;
    }

    public void setResumed(boolean resumed) {
        this.resumed = resumed;
    }
}

