/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.completions.externaltype;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springsource.ide.eclipse.commons.completions.CompletionsActivator;
import org.springsource.ide.eclipse.commons.completions.externaltype.AbstractExternalTypeSource;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeDiscovery;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeEntry;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeSource;
import org.springsource.ide.eclipse.commons.completions.util.Requestor;

public class JarTypeDiscovery
extends AbstractExternalTypeSource
implements ExternalTypeDiscovery {
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("kdvolder");
    private final File jarFile;

    public JarTypeDiscovery(File jarFile) {
        this.jarFile = jarFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getTypes(Requestor<ExternalTypeEntry> requestor) {
        ZipFile unzipper = null;
        try {
            try {
                unzipper = new ZipFile(this.jarFile);
                Enumeration<? extends ZipEntry> entries = unzipper.entries();
                boolean continu = true;
                while (entries.hasMoreElements()) {
                    if (!continu) {
                        return;
                    }
                    ZipEntry e = entries.nextElement();
                    String path = e.getName();
                    if (!path.endsWith(".class") || path.contains("$") || path.lastIndexOf(47) <= 1) continue;
                    int beg = path.charAt(0) == '/' ? 1 : 0;
                    String fqName = path.substring(beg, path.length() - 6);
                    fqName = fqName.replace('/', '.');
                    continu = requestor.receive(this.debug(new ExternalTypeEntry(fqName, this.getTypeSource())));
                }
                return;
            }
            catch (Exception e) {
                CompletionsActivator.log(e);
                if (unzipper == null) return;
                try {
                    unzipper.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
        finally {
            if (unzipper != null) {
                try {
                    unzipper.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ExternalTypeEntry debug(ExternalTypeEntry externalTypeEntry) {
        if (DEBUG) {
            System.out.println(externalTypeEntry);
        }
        return externalTypeEntry;
    }

    protected ExternalTypeSource getTypeSource() {
        return this;
    }

    public String toString() {
        return "JarTypeDiscovery[" + this.jarFile + "]";
    }

    @Override
    public void addToClassPath(IJavaProject project, IProgressMonitor mon) {
        try {
            IClasspathEntry[] _cpes = project.getRawClasspath();
            IClasspathEntry[] cpes = new IClasspathEntry[_cpes.length + 1];
            System.arraycopy(_cpes, 0, cpes, 0, _cpes.length);
            cpes[_cpes.length] = JavaCore.newLibraryEntry((IPath)new Path(this.jarFile.getAbsolutePath()), null, null);
            project.setRawClasspath(cpes, mon);
        }
        catch (Exception e) {
            CompletionsActivator.log(e);
        }
    }
}

