/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.completions.constructors;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.complete.CompletionNodeFound;
import org.eclipse.jdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.jdt.internal.codeassist.complete.InvalidCursorLocation;
import org.eclipse.jdt.internal.codeassist.impl.Engine;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessConstructorRequestor;
import org.springsource.ide.eclipse.commons.completions.CompletionsActivator;
import org.springsource.ide.eclipse.commons.frameworks.core.async.ConstructorSearchValueProvider;
import org.springsource.ide.eclipse.commons.frameworks.core.async.JavaConstructorHint;

public class ConstructorCompletionEngine {
    private CompletionEngine engine;
    private ConstructorSearchValueProvider constructorValueProvider;

    public ConstructorCompletionEngine(ICompilationUnit compilationUnit, CompletionRequestor requestor, SearchableEnvironment searchableEnv, JavaProject javaProject, WorkingCopyOwner owner, ConstructorSearchValueProvider constructorValueProvider, IProgressMonitor monitor) {
        this.engine = new CompletionEngine(searchableEnv, requestor, javaProject.getOptions(true), (IJavaProject)javaProject, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, monitor);
        this.constructorValueProvider = constructorValueProvider;
    }

    public void complete(ICompilationUnit sourceUnit, int pos, ITypeRoot root, IType expectedType) {
        block18: {
            this.getEngineFieldValue("requestor", CompletionRequestor.class).beginReporting();
            try {
                try {
                    this.setEngineFieldValue("fileName", sourceUnit.getFileName());
                    this.setEngineFieldValue("offset", 0);
                    this.setEngineFieldValue("actualCompletionPosition", pos - 1);
                    this.setEngineFieldValue("typeRoot", root);
                    CompilationResult result = new CompilationResult(sourceUnit, 1, 1, this.engine.compilerOptions.maxProblemsPerUnit);
                    CompilationUnitDeclaration parsedUnit = ((CompletionParser)this.engine.getParser()).dietParse(sourceUnit, result, pos - 1);
                    if (parsedUnit == null || parsedUnit.types == null) break block18;
                    try {
                        this.engine.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                        this.setEngineFieldValue("unitScope", parsedUnit.scope);
                        if (parsedUnit.scope != null) {
                            this.setEngineFieldValue("source", sourceUnit.getContents());
                            this.engine.lookupEnvironment.completeTypeBindings(parsedUnit, true);
                            parsedUnit.scope.faultInTypes();
                            this.parseBlockStatements(parsedUnit, pos - 1);
                            parsedUnit.resolve();
                        }
                    }
                    catch (CompletionNodeFound e) {
                        if (e.astNode == null) break block18;
                        this.engine.lookupEnvironment.unitBeingCompleted = parsedUnit;
                        try {
                            this.complete(e.astNode, ((CompletionParser)this.engine.getParser()).assistNodeParent, parsedUnit, e.qualifiedBinding, e.scope, expectedType, this.getEngineFieldValue("monitor", IProgressMonitor.class));
                        }
                        catch (JavaModelException e1) {
                            CompletionsActivator.log(e1.getStatus());
                        }
                    }
                }
                catch (IndexOutOfBoundsException | CompletionNodeFound | InvalidCursorLocation | AbortCompilation e) {
                    CompletionsActivator.log(e);
                    this.getEngineFieldValue("requestor", CompletionRequestor.class).endReporting();
                    if (this.getEngineFieldValue("monitor", IProgressMonitor.class) != null) {
                        this.getEngineFieldValue("monitor", IProgressMonitor.class).done();
                    }
                    try {
                        Method method = CompletionEngine.class.getDeclaredMethod("reset", new Class[0]);
                        method.setAccessible(true);
                        method.invoke((Object)this.engine, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                        CompletionsActivator.log(e2);
                    }
                }
            }
            finally {
                this.getEngineFieldValue("requestor", CompletionRequestor.class).endReporting();
                if (this.getEngineFieldValue("monitor", IProgressMonitor.class) != null) {
                    this.getEngineFieldValue("monitor", IProgressMonitor.class).done();
                }
                try {
                    Method method = CompletionEngine.class.getDeclaredMethod("reset", new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)this.engine, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    CompletionsActivator.log(e);
                }
            }
        }
    }

    private void setEngineFieldValue(String name, Object value) {
        try {
            Field field = null;
            try {
                field = this.engine.getClass().getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                field = Engine.class.getDeclaredField(name);
            }
            field.setAccessible(true);
            field.set(this.engine, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            CompletionsActivator.log(e);
        }
    }

    private <T> T getEngineFieldValue(String name, Class<T> clazz) {
        try {
            Field field = this.engine.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(this.engine);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            CompletionsActivator.log(e);
            return null;
        }
    }

    private ASTNode parseBlockStatements(CompilationUnitDeclaration unit, int position) {
        try {
            Method method = Engine.class.getDeclaredMethod("parseBlockStatements", CompilationUnitDeclaration.class, Integer.TYPE);
            method.setAccessible(true);
            return (ASTNode)method.invoke((Object)this.engine, unit, position);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            CompletionsActivator.log(e);
            return null;
        }
    }

    private void complete(ASTNode astNode, ASTNode astNodeParent, CompilationUnitDeclaration compilationUnitDeclaration, Binding qualifiedBinding, Scope scope, IType expectedType, IProgressMonitor monitor) throws JavaModelException {
        try {
            this.setEngineFieldValue("completionToken", new char[0]);
            Method m = this.engine.getClass().getDeclaredMethod("setSourceAndTokenRange", Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            m.invoke((Object)this.engine, astNode.sourceStart, astNode.sourceEnd);
            m = this.engine.getClass().getDeclaredMethod("computeForbiddenBindings", ASTNode.class, ASTNode.class, Scope.class);
            m.setAccessible(true);
            scope = (Scope)m.invoke((Object)this.engine, astNode, astNodeParent, scope);
            m = this.engine.getClass().getDeclaredMethod("computeUninterestingBindings", ASTNode.class, ASTNode.class, Scope.class);
            m.setAccessible(true);
            m.invoke((Object)this.engine, astNode, astNodeParent, scope);
            m = this.engine.getClass().getDeclaredMethod("buildContext", ASTNode.class, ASTNode.class, CompilationUnitDeclaration.class, Binding.class, Scope.class);
            m.setAccessible(true);
            m.invoke((Object)this.engine, astNode, astNodeParent, compilationUnitDeclaration, qualifiedBinding, scope);
            this.performAsyncSearchAndReadFromCache(expectedType, monitor);
            m = this.engine.getClass().getDeclaredMethod("acceptConstructors", Scope.class);
            if (m != null) {
                m.setAccessible(true);
                m.invoke((Object)this.engine, scope);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            CompletionsActivator.log(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof OperationCanceledException) {
                throw (OperationCanceledException)e.getCause();
            }
            CompletionsActivator.log(e);
        }
    }

    private void performLegacySyncSearch(IType expectedType, IProgressMonitor monitor) throws JavaModelException {
        HierarchyScope hierarchyScope = this.getScope(expectedType);
        BasicSearchEngine basicEngine = new BasicSearchEngine();
        basicEngine.searchAllConstructorDeclarations(null, "*".toCharArray(), 2, (IJavaSearchScope)hierarchyScope, new IRestrictedAccessConstructorRequestor(){

            public void acceptConstructor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, String path, AccessRestriction access) {
                ConstructorCompletionEngine.this.engine.acceptConstructor(modifiers, simpleTypeName, parameterCount, signature, parameterTypes, parameterNames, typeModifiers, packageName, extraFlags, path, access);
            }
        }, 1, monitor);
    }

    private void performAsyncSearchAndReadFromCache(IType expectedType, IProgressMonitor monitor) throws JavaModelException {
        HierarchyScope scope = this.getScope(expectedType);
        Collection values = this.constructorValueProvider.getValuesNow(expectedType, (IJavaSearchScope)scope);
        if (values != null) {
            for (JavaConstructorHint javaConstructorHint : values) {
                this.engine.acceptConstructor(javaConstructorHint.modifiers, javaConstructorHint.simpleTypeName, javaConstructorHint.parameterCount, javaConstructorHint.signature, javaConstructorHint.parameterTypes, javaConstructorHint.parameterNames, javaConstructorHint.typeModifiers, javaConstructorHint.packageName, javaConstructorHint.extraFlags, javaConstructorHint.path, javaConstructorHint.access);
            }
        }
    }

    private HierarchyScope getScope(IType expectedType) throws JavaModelException {
        return new HierarchyScope(this.getEngineFieldValue("javaProject", IJavaProject.class), expectedType, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, true, false, false);
    }
}

