/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.sonarlint.eclipse.core.internal.tracking.Input;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.internal.tracking.Tracking;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;

public class Tracker<RAW extends Trackable, BASE extends Trackable> {
    public Tracking<RAW, BASE> track(Input<RAW> rawInput, Input<BASE> baseInput) {
        Tracking<RAW, BASE> tracking = new Tracking<RAW, BASE>(rawInput, baseInput);
        this.match(tracking, LineAndTextRangeHashKeyFactory.INSTANCE);
        this.match(tracking, TextRangeHashAndMessageKeyFactory.INSTANCE);
        this.match(tracking, LineAndMessageKeyFactory.INSTANCE);
        this.match(tracking, TextRangeHashKeyFactory.INSTANCE);
        this.match(tracking, LineAndLineHashKeyFactory.INSTANCE);
        this.match(tracking, LineHashKeyFactory.INSTANCE);
        this.match(tracking, ServerIssueSearchKeyFactory.INSTANCE);
        return tracking;
    }

    private void match(Tracking<RAW, BASE> tracking, SearchKeyFactory factory) {
        if (tracking.isComplete()) {
            return;
        }
        HashMap baseSearch = new HashMap();
        for (Trackable base : tracking.getUnmatchedBases()) {
            SearchKey searchKey = factory.apply(base);
            if (!baseSearch.containsKey(searchKey)) {
                baseSearch.put(searchKey, new ArrayList());
            }
            ((List)baseSearch.get(searchKey)).add(base);
        }
        for (Trackable raw : tracking.getUnmatchedRaws()) {
            SearchKey rawKey = factory.apply(raw);
            Collection bases = (Collection)baseSearch.get(rawKey);
            if (bases == null || bases.isEmpty()) continue;
            Trackable match = (Trackable)bases.iterator().next();
            tracking.match(raw, match);
            ((List)baseSearch.get(rawKey)).remove(match);
        }
    }

    private static class LineAndLineHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer line;
        private final Integer lineHash;

        LineAndLineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.line = trackable.getLine();
            this.lineHash = trackable.getLineHash();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            LineAndLineHashKey that = (LineAndLineHashKey)o;
            return Objects.equals(this.line, that.line) && Objects.equals(this.lineHash, that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.lineHash != null ? this.lineHash.hashCode() : 0);
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    private static enum LineAndLineHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new LineAndLineHashKey(t);
        }
    }

    private static class LineAndMessageKey
    implements SearchKey {
        private final String ruleKey;
        private final String message;
        private final Integer line;

        LineAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.line = trackable.getLine();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            LineAndMessageKey that = (LineAndMessageKey)o;
            return Objects.equals(this.line, that.line) && this.message.equals(that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    private static enum LineAndMessageKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new LineAndMessageKey(t);
        }
    }

    private static class LineAndTextRangeHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer textRangeHash;
        private final Integer line;

        LineAndTextRangeHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.line = trackable.getLine();
            this.textRangeHash = trackable.getTextRangeHash();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            LineAndTextRangeHashKey that = (LineAndTextRangeHashKey)o;
            return Objects.equals(this.line, that.line) && Objects.equals(this.textRangeHash, that.textRangeHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.textRangeHash != null ? this.textRangeHash.hashCode() : 0);
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    private static enum LineAndTextRangeHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new LineAndTextRangeHashKey(t);
        }
    }

    private static class LineHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer lineHash;

        LineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.lineHash = trackable.getLineHash();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            LineHashKey that = (LineHashKey)o;
            return Objects.equals(this.lineHash, that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.lineHash != null ? this.lineHash.hashCode() : 0);
            return result;
        }
    }

    private static enum LineHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new LineHashKey(t);
        }
    }

    private static interface SearchKey {
    }

    @FunctionalInterface
    private static interface SearchKeyFactory
    extends Function<Trackable, SearchKey> {
        @Override
        public SearchKey apply(Trackable var1);
    }

    private static class ServerIssueSearchKey
    implements SearchKey {
        private final String serverIssueKey;

        ServerIssueSearchKey(Trackable trackable) {
            this.serverIssueKey = trackable.getServerIssueKey();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServerIssueSearchKey that = (ServerIssueSearchKey)o;
            return !StringUtils.isBlank(this.serverIssueKey) && !StringUtils.isBlank(that.serverIssueKey) && this.serverIssueKey.equals(that.serverIssueKey);
        }

        public int hashCode() {
            return this.serverIssueKey != null ? this.serverIssueKey.hashCode() : 0;
        }
    }

    private static enum ServerIssueSearchKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable trackable) {
            return new ServerIssueSearchKey(trackable);
        }
    }

    private static class TextRangeHashAndMessageKey
    implements SearchKey {
        private final String ruleKey;
        private final String message;
        private final Integer textRangeHash;

        TextRangeHashAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.textRangeHash = trackable.getTextRangeHash();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            TextRangeHashAndMessageKey that = (TextRangeHashAndMessageKey)o;
            return Objects.equals(this.textRangeHash, that.textRangeHash) && this.message.equals(that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + (this.textRangeHash != null ? this.textRangeHash.hashCode() : 0);
            return result;
        }
    }

    private static enum TextRangeHashAndMessageKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new TextRangeHashAndMessageKey(t);
        }
    }

    private static class TextRangeHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer textRangeHash;

        TextRangeHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.textRangeHash = trackable.getTextRangeHash();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            TextRangeHashKey that = (TextRangeHashKey)o;
            return Objects.equals(this.textRangeHash, that.textRangeHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.textRangeHash != null ? this.textRangeHash.hashCode() : 0);
            return result;
        }
    }

    private static enum TextRangeHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new TextRangeHashKey(t);
        }
    }
}

