/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.sonarlint.eclipse.core.internal.tracking.CombinedTrackable;
import org.sonarlint.eclipse.core.internal.tracking.DisconnectedTrackable;
import org.sonarlint.eclipse.core.internal.tracking.IssueTrackerCache;
import org.sonarlint.eclipse.core.internal.tracking.LeakedTrackable;
import org.sonarlint.eclipse.core.internal.tracking.PreviousTrackable;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.internal.tracking.Tracker;
import org.sonarlint.eclipse.core.internal.tracking.Tracking;

public class IssueTracker {
    private final IssueTrackerCache cache;

    public IssueTracker(IssueTrackerCache cache) {
        this.cache = cache;
    }

    public synchronized Collection<Trackable> matchAndTrackAsNew(String file, Collection<Trackable> rawIssues) {
        Collection<Trackable> tracked;
        if (this.cache.isFirstAnalysis(file)) {
            tracked = rawIssues;
        } else {
            ArrayList<Trackable> trackedIssues = new ArrayList<Trackable>();
            Tracking tracking = new Tracker().track(() -> rawIssues, () -> this.cache.getCurrentTrackables(file));
            for (Map.Entry entry : tracking.getMatchedRaws().entrySet()) {
                PreviousTrackable next = new PreviousTrackable((Trackable)entry.getValue(), (Trackable)entry.getKey());
                trackedIssues.add(next);
            }
            for (Trackable raw : tracking.getUnmatchedRaws()) {
                trackedIssues.add(new LeakedTrackable(raw));
            }
            tracked = trackedIssues;
        }
        return tracked;
    }

    public synchronized void updateCache(String file, Collection<Trackable> tracked) {
        this.cache.put(file, tracked);
    }

    public synchronized Collection<Trackable> matchAndTrackServerIssues(String file, Collection<Trackable> serverIssues) {
        Collection<Trackable> current = this.cache.getLiveOrFail(file);
        if (current.isEmpty()) {
            return Collections.emptyList();
        }
        return IssueTracker.matchAndTrackServerIssues(serverIssues, current);
    }

    public static Collection<Trackable> matchAndTrackServerIssues(Collection<Trackable> serverIssues, Collection<Trackable> currentIssues) {
        ArrayList<Trackable> trackedIssues = new ArrayList<Trackable>();
        Tracking tracking = new Tracker().track(() -> currentIssues, () -> serverIssues);
        for (Map.Entry entry : tracking.getMatchedRaws().entrySet()) {
            CombinedTrackable next = new CombinedTrackable((Trackable)entry.getValue(), (Trackable)entry.getKey());
            trackedIssues.add(next);
        }
        for (Trackable next : tracking.getUnmatchedRaws()) {
            if (next.getServerIssueKey() != null) {
                next = new DisconnectedTrackable(next);
            } else if (next.getCreationDate() == null) {
                next = new LeakedTrackable(next);
            }
            trackedIssues.add(next);
        }
        return trackedIssues;
    }

    public void clear() {
        this.cache.clear();
    }

    public void shutdown() {
        this.cache.shutdown();
    }
}

