/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.IServerLifecycleListener;
import org.sonarlint.eclipse.core.internal.server.Server;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;

public class ServersManager {
    static final String PREF_SERVERS = "servers";
    static final String AUTH_ATTRIBUTE = "auth";
    static final String URL_ATTRIBUTE = "url";
    static final String ORG_ATTRIBUTE = "org";
    static final String USERNAME_ATTRIBUTE = "username";
    static final String PASSWORD_ATTRIBUTE = "password";
    static final String NOTIFICATIONS_ENABLED_ATTRIBUTE = "notificationsEnabled";
    private static final byte EVENT_ADDED = 0;
    private static final byte EVENT_CHANGED = 1;
    private static final byte EVENT_REMOVED = 2;
    private final Map<String, IServer> serversById = new LinkedHashMap<String, IServer>();
    private final List<IServerLifecycleListener> serverListeners = new ArrayList<IServerLifecycleListener>();
    private final IEclipsePreferences.IPreferenceChangeListener serverChangeListener = event -> {
        try {
            if (!event.getNode().nodeExists("") || !event.getNode().parent().nodeExists("")) {
                return;
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(e);
        }
        String serverId = ServersManager.getServerIdFromNodeName(event.getNode().name());
        Server old = (Server)this.serversById.get(serverId);
        if (old != null) {
            ServersManager.loadServer(event.getNode(), old);
            old.stop();
            this.fireServerEvent(old, (byte)1);
        } else {
            Server newServer = new Server(serverId);
            ServersManager.loadServer(event.getNode(), newServer);
            this.serversById.put(newServer.getId(), newServer);
            this.fireServerEvent(newServer, (byte)0);
        }
    };
    private final IEclipsePreferences.INodeChangeListener serversNodeChangeListener = new IEclipsePreferences.INodeChangeListener(){

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            String serverId = ServersManager.getServerIdFromNodeName(event.getChild().name());
            IServer serverToRemove = (IServer)ServersManager.this.serversById.get(serverId);
            ServersManager.this.serversById.remove(serverId);
            if (serverToRemove != null) {
                ServersManager.this.fireServerEvent(serverToRemove, (byte)2);
            }
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            ((IEclipsePreferences)event.getChild()).addPreferenceChangeListener(ServersManager.this.serverChangeListener);
        }
    };
    private final IEclipsePreferences.INodeChangeListener rootNodeChangeListener = new IEclipsePreferences.INodeChangeListener(){

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (event.getChild().name().equals(ServersManager.PREF_SERVERS)) {
                ArrayList removedServers = new ArrayList(ServersManager.this.serversById.values());
                ServersManager.this.serversById.clear();
                for (IServer server : removedServers) {
                    ServersManager.this.fireServerEvent(server, (byte)2);
                }
                ServersManager.this.serversById.putAll(ServersManager.loadServersList(DefaultScope.INSTANCE.getNode("org.sonarlint.eclipse.core").node(ServersManager.PREF_SERVERS)));
                for (IServer server : ServersManager.this.serversById.values()) {
                    ServersManager.this.fireServerEvent(server, (byte)0);
                }
            }
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            if (event.getChild().name().equals(ServersManager.PREF_SERVERS)) {
                ArrayList removedServers = new ArrayList(ServersManager.this.serversById.values());
                ServersManager.this.serversById.clear();
                for (IServer server : removedServers) {
                    ServersManager.this.fireServerEvent(server, (byte)2);
                }
                ((IEclipsePreferences)event.getChild()).addNodeChangeListener(ServersManager.this.serversNodeChangeListener);
            }
        }
    };

    public void init() {
        IEclipsePreferences rootNode = ServersManager.getSonarLintPreferenceNode();
        rootNode.addNodeChangeListener(this.rootNodeChangeListener);
        try {
            if (rootNode.nodeExists(PREF_SERVERS)) {
                Preferences serversNode = rootNode.node(PREF_SERVERS);
                ((IEclipsePreferences)serversNode).addNodeChangeListener(this.serversNodeChangeListener);
                this.serversById.putAll(ServersManager.loadServersList(serversNode));
                String[] stringArray = serversNode.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String serverNodeName = stringArray[n2];
                    IEclipsePreferences serverNode = (IEclipsePreferences)serversNode.node(serverNodeName);
                    serverNode.addPreferenceChangeListener(this.serverChangeListener);
                    ++n2;
                }
            } else {
                this.serversById.putAll(ServersManager.loadServersList(DefaultScope.INSTANCE.getNode("org.sonarlint.eclipse.core").node(PREF_SERVERS)));
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Unable to load server list", e);
        }
    }

    public void stop() {
        IEclipsePreferences rootNode = ServersManager.getSonarLintPreferenceNode();
        rootNode.removeNodeChangeListener(this.rootNodeChangeListener);
        try {
            if (rootNode.nodeExists(PREF_SERVERS)) {
                Preferences serversNode = rootNode.node(PREF_SERVERS);
                ((IEclipsePreferences)serversNode).removeNodeChangeListener(this.serversNodeChangeListener);
                String[] stringArray = serversNode.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String serverNodeName = stringArray[n2];
                    IEclipsePreferences serverNode = (IEclipsePreferences)serversNode.node(serverNodeName);
                    serverNode.removePreferenceChangeListener(this.serverChangeListener);
                    ++n2;
                }
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Unable to load server list", e);
        }
        this.serverListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerLifecycleListener(IServerLifecycleListener listener) {
        List<IServerLifecycleListener> list = this.serverListeners;
        synchronized (list) {
            this.serverListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerLifecycleListener(IServerLifecycleListener listener) {
        List<IServerLifecycleListener> list = this.serverListeners;
        synchronized (list) {
            this.serverListeners.remove(listener);
        }
    }

    private void fireServerEvent(IServer server, byte b) {
        if (this.serverListeners.isEmpty()) {
            return;
        }
        ArrayList<IServerLifecycleListener> clone = new ArrayList<IServerLifecycleListener>();
        clone.addAll(this.serverListeners);
        for (IServerLifecycleListener srl : clone) {
            if (b == 0) {
                srl.serverAdded(server);
                continue;
            }
            if (b == 1) {
                srl.serverChanged(server);
                continue;
            }
            srl.serverRemoved(server);
        }
    }

    private static IEclipsePreferences getSonarLintPreferenceNode() {
        return InstanceScope.INSTANCE.getNode("org.sonarlint.eclipse.core");
    }

    private static Map<String, IServer> loadServersList(Preferences serversNode) {
        LinkedHashMap<String, IServer> result = new LinkedHashMap<String, IServer>();
        try {
            String[] stringArray = serversNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String serverNodeName = stringArray[n2];
                Preferences serverNode = serversNode.node(serverNodeName);
                String serverId = ServersManager.getServerIdFromNodeName(serverNodeName);
                Server s = new Server(serverId);
                ServersManager.loadServer(serverNode, s);
                result.put(s.getId(), s);
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Unable to load server list", e);
        }
        return result;
    }

    private static void loadServer(Preferences serverNode, Server server) {
        String url = serverNode.get(URL_ATTRIBUTE, "");
        if ("https://sonarqube.com".equals(url = StringUtils.removeEnd(url, "/"))) {
            url = "https://sonarcloud.io";
            serverNode.put(URL_ATTRIBUTE, url);
        }
        ServersManager.update(server, url, serverNode.get(ORG_ATTRIBUTE, null), serverNode.getBoolean(AUTH_ATTRIBUTE, false), serverNode.getBoolean(NOTIFICATIONS_ENABLED_ATTRIBUTE, false));
    }

    private static String getServerIdFromNodeName(String name) {
        return StringUtils.urlDecode(name);
    }

    public void addServer(IServer server, String username, String password) {
        if (this.serversById.containsKey(server.getId())) {
            throw new IllegalStateException("There is already a server with id '" + server.getId() + "'");
        }
        if (server.hasAuth()) {
            ServersManager.storeCredentials(server, username, password);
        }
        this.addOrUpdateProperties(server);
        this.serversById.put(server.getId(), server);
        this.fireServerEvent(server, (byte)0);
    }

    private static void storeCredentials(IServer server, String username, String password) {
        try {
            ISecurePreferences secureServersNode = ServersManager.getSecureServersNode();
            ISecurePreferences secureServerNode = secureServersNode.node(ServersManager.getServerNodeName(server));
            secureServerNode.put(USERNAME_ATTRIBUTE, username, true);
            secureServerNode.put(PASSWORD_ATTRIBUTE, password, true);
            secureServersNode.flush();
        }
        catch (IOException | StorageException e) {
            throw new IllegalStateException("Unable to store server credentials in secure storage: " + e.getMessage(), e);
        }
    }

    public void removeServer(IServer server) {
        String serverNodeName = ServersManager.getServerNodeName(server);
        try {
            IEclipsePreferences rootNode = ServersManager.getSonarLintPreferenceNode();
            Preferences serversNode = rootNode.node(PREF_SERVERS);
            if (serversNode.nodeExists(serverNodeName)) {
                ((IEclipsePreferences)serversNode.node(serverNodeName)).removePreferenceChangeListener(this.serverChangeListener);
                serversNode.node(serverNodeName).removeNode();
                serversNode.flush();
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Unable to save server list", e);
        }
        ServersManager.tryRemoveSecureProperties(serverNodeName);
    }

    private static void tryRemoveSecureProperties(String serverNodeName) {
        ISecurePreferences secureServersNode = ServersManager.getSecureServersNode();
        if (secureServersNode.nodeExists(serverNodeName)) {
            secureServersNode.node(serverNodeName).removeNode();
        }
    }

    public List<IServer> getServers() {
        return this.getServersNoInit();
    }

    public List<IServer> getServersNoInit() {
        return Collections.unmodifiableList(new ArrayList<IServer>(this.serversById.values()));
    }

    @CheckForNull
    public IServer getServer(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.serversById.get(id);
    }

    public void updateServer(IServer server, String username, String password) {
        if (server == null) {
            return;
        }
        if (!this.serversById.containsKey(server.getId())) {
            throw new IllegalStateException("There is no server with id '" + server.getId() + "'");
        }
        IEclipsePreferences rootNode = ServersManager.getSonarLintPreferenceNode();
        try {
            if (!rootNode.nodeExists(PREF_SERVERS)) {
                ArrayList<IServer> defaultServers = new ArrayList<IServer>(this.serversById.values());
                this.serversById.clear();
                for (IServer iServer : defaultServers) {
                    this.addServer(iServer, null, null);
                }
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Unable to save server", e);
        }
        this.addOrUpdateProperties(server);
        if (server.hasAuth()) {
            ServersManager.storeCredentials(server, username, password);
        }
        Server serverToUpdate = (Server)this.serversById.get(server.getId());
        ServersManager.update(serverToUpdate, server.getHost(), server.getOrganization(), server.hasAuth(), server.areNotificationsEnabled());
        this.fireServerEvent(serverToUpdate, (byte)1);
    }

    private void addOrUpdateProperties(IServer server) {
        IEclipsePreferences rootNode = ServersManager.getSonarLintPreferenceNode();
        Preferences serversNode = rootNode.node(PREF_SERVERS);
        IEclipsePreferences serverNode = (IEclipsePreferences)serversNode.node(ServersManager.getServerNodeName(server));
        try {
            try {
                serverNode.removePreferenceChangeListener(this.serverChangeListener);
                serverNode.put(URL_ATTRIBUTE, server.getHost());
                if (StringUtils.isNotBlank(server.getOrganization())) {
                    serverNode.put(ORG_ATTRIBUTE, server.getOrganization());
                }
                serverNode.putBoolean(AUTH_ATTRIBUTE, server.hasAuth());
                serverNode.putBoolean(NOTIFICATIONS_ENABLED_ATTRIBUTE, server.areNotificationsEnabled());
                serversNode.flush();
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException("Unable to save server list", e);
            }
        }
        finally {
            serverNode.addPreferenceChangeListener(this.serverChangeListener);
        }
    }

    public static String getUsername(IServer server) throws StorageException {
        return ServersManager.getFromSecure(server, USERNAME_ATTRIBUTE);
    }

    public static String getPassword(IServer server) throws StorageException {
        return ServersManager.getFromSecure(server, PASSWORD_ATTRIBUTE);
    }

    private static String getFromSecure(IServer server, String attribute) throws StorageException {
        ISecurePreferences secureServersNode = ServersManager.getSecureServersNode();
        if (!secureServersNode.nodeExists(ServersManager.getServerNodeName(server))) {
            return null;
        }
        ISecurePreferences secureServerNode = secureServersNode.node(ServersManager.getServerNodeName(server));
        return secureServerNode.get(attribute, null);
    }

    private static ISecurePreferences getSecureServersNode() {
        return SecurePreferencesFactory.getDefault().node("org.sonarlint.eclipse.core").node(PREF_SERVERS);
    }

    private static String getServerNodeName(IServer server) {
        return StringUtils.urlEncode(server.getId());
    }

    public String validate(String serverId, boolean editExisting) {
        if (StringUtils.isBlank(serverId)) {
            return "Connection name must be specified";
        }
        if (!editExisting && this.serversById.containsKey(serverId)) {
            return "Connection name already exists";
        }
        try {
            ConnectedGlobalConfiguration.builder().setServerId(serverId).build();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public IServer create(String id, String url, @Nullable String organization, String username, String password, boolean notificationsEnabled) {
        return ServersManager.update(new Server(id), url, organization, StringUtils.isNotBlank(username) || StringUtils.isNotBlank(password), notificationsEnabled);
    }

    private static Server update(Server server, String url, @Nullable String organization, boolean hasAuth, boolean notificationsEnabled) {
        return server.setHost(url).setOrganization(organization).setHasAuth(hasAuth).setNotificationsEnabled(notificationsEnabled);
    }
}

