/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.server;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.framework.Version;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.StoragePathManager;
import org.sonarlint.eclipse.core.internal.jobs.SonarLintAnalyzerLogOutput;
import org.sonarlint.eclipse.core.internal.jobs.WrappedProgressMonitor;
import org.sonarlint.eclipse.core.internal.resources.ProjectsProviderUtils;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.IServerListener;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.core.internal.utils.SonarLintUtils;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarsource.sonarlint.core.ConnectedSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.WsHelperImpl;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.ProgressMonitor;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalStorageStatus;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteOrganization;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.SonarAnalyzer;
import org.sonarsource.sonarlint.core.client.api.connected.StateListener;
import org.sonarsource.sonarlint.core.client.api.connected.StorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.client.api.connected.UpdateResult;
import org.sonarsource.sonarlint.core.client.api.connected.ValidationResult;
import org.sonarsource.sonarlint.core.client.api.exceptions.DownloadException;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;
import org.sonarsource.sonarlint.core.notifications.SonarQubeNotifications;

public class Server
implements IServer,
StateListener {
    public static final String SONARCLOUD_URL = "https://sonarcloud.io";
    public static final String OLD_SONARCLOUD_URL = "https://sonarqube.com";
    private static final String NEED_UPDATE = "Need data update";
    private final String id;
    private String host;
    private String organization;
    private boolean hasAuth;
    private final ConnectedSonarLintEngine client;
    private final List<IServerListener> listeners = new ArrayList<IServerListener>();
    private GlobalStorageStatus updateStatus;
    private boolean hasUpdates;
    private boolean notificationsEnabled;

    Server(String id) {
        this.id = id;
        ConnectedGlobalConfiguration globalConfig = ((ConnectedGlobalConfiguration.Builder)((ConnectedGlobalConfiguration.Builder)ConnectedGlobalConfiguration.builder().setServerId(this.getId()).setWorkDir(StoragePathManager.getServerWorkDir(this.getId()))).setStorageRoot(StoragePathManager.getServerStorageRoot()).setLogOutput((LogOutput)new SonarLintAnalyzerLogOutput())).build();
        this.client = new ConnectedSonarLintEngineImpl(globalConfig);
        this.client.addStateListener((StateListener)this);
        this.updateStatus = this.client.getGlobalStorageStatus();
    }

    public void stateChanged(ConnectedSonarLintEngine.State state) {
        this.notifyAllListeners();
    }

    @Override
    public void notifyAllListeners() {
        for (IServerListener listener : this.listeners) {
            listener.accept(this);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public Server setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    public Server setOrganization(@Nullable String organization) {
        this.organization = organization;
        return this;
    }

    @Override
    public boolean hasAuth() {
        return this.hasAuth;
    }

    public Server setHasAuth(boolean hasAuth) {
        this.hasAuth = hasAuth;
        return this;
    }

    @Override
    public boolean isStorageUpdated() {
        return this.client.getState() == ConnectedSonarLintEngine.State.UPDATED;
    }

    @Override
    public void checkForUpdates(IProgressMonitor progress) {
        this.hasUpdates = false;
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.getBoundProjects().size() + 1));
            SubMonitor globalMonitor = subMonitor.newChild(1);
            SonarLintLogger.get().info("Check for updates from server '" + this.getId() + "'");
            StorageUpdateCheckResult checkForUpdateResult = this.client.checkIfGlobalStorageNeedUpdate(this.getConfig(), (ProgressMonitor)new WrappedProgressMonitor((IProgressMonitor)globalMonitor, "Check for configuration updates on server '" + this.getId() + "'"));
            if (checkForUpdateResult.needUpdate()) {
                this.hasUpdates = true;
                checkForUpdateResult.changelog().forEach(line -> SonarLintLogger.get().info("  - " + line));
            }
            for (ISonarLintProject boundProject : this.getBoundProjects()) {
                SubMonitor projectMonitor = subMonitor.newChild(1);
                if (progress.isCanceled()) {
                    return;
                }
                try {
                    SonarLintLogger.get().info("Check for updates from server '" + this.getId() + "' for project '" + boundProject.getName() + "'");
                    SonarLintProjectConfiguration projectConfig = SonarLintProjectConfiguration.read(boundProject.getScopeContext());
                    StorageUpdateCheckResult moduleUpdateCheckResult = this.client.checkIfModuleStorageNeedUpdate(this.getConfig(), projectConfig.getModuleKey(), (ProgressMonitor)new WrappedProgressMonitor((IProgressMonitor)projectMonitor, "Checking for configuration update for project '" + boundProject.getName() + "'"));
                    if (!moduleUpdateCheckResult.needUpdate()) continue;
                    this.hasUpdates = true;
                    SonarLintLogger.get().info("On project '" + boundProject.getName() + "':");
                    moduleUpdateCheckResult.changelog().forEach(line -> SonarLintLogger.get().info("  - " + line));
                    continue;
                }
                catch (DownloadException e) {
                    SonarLintLogger.get().debug("Unable to check for update on server '" + this.getId() + "'", e);
                }
                break;
            }
        }
        finally {
            this.notifyAllListeners();
        }
    }

    @Override
    public boolean hasUpdates() {
        return this.hasUpdates;
    }

    @Override
    public String getServerVersion() {
        if (!this.isStorageUpdated()) {
            return NEED_UPDATE;
        }
        return this.updateStatus.getServerVersion();
    }

    @Override
    public String getUpdateDate() {
        if (!this.isStorageUpdated()) {
            return NEED_UPDATE;
        }
        return new SimpleDateFormat().format(this.updateStatus.getLastUpdateDate());
    }

    @Override
    public boolean isUpdating() {
        return ConnectedSonarLintEngine.State.UPDATING == this.client.getState();
    }

    @Override
    public String getSonarLintEngineState() {
        switch (this.client.getState()) {
            case UNKNOW: {
                return "Unknown";
            }
            case NEVER_UPDATED: 
            case NEED_UPDATE: {
                return NEED_UPDATE;
            }
            case UPDATED: {
                StringBuilder sb = new StringBuilder();
                sb.append("Version: ");
                sb.append(this.getServerVersion());
                sb.append(", Last update: ");
                sb.append(this.getUpdateDate());
                if (this.hasUpdates) {
                    sb.append(", New updates available");
                }
                return sb.toString();
            }
            case UPDATING: {
                return "Updating data...";
            }
        }
        throw new IllegalArgumentException(this.client.getState().name());
    }

    @Override
    public synchronized void delete() {
        this.client.stop(true);
        for (ISonarLintProject sonarLintProject : this.getBoundProjects()) {
            Server.unbind(sonarLintProject);
        }
        SonarLintCorePlugin.getServersManager().removeServer(this);
    }

    public static void unbind(ISonarLintProject project) {
        SonarLintCorePlugin.getInstance().notificationsManager().unsubscribe(project);
        SonarLintProjectConfiguration.read(project.getScopeContext()).unbind();
        project.deleteAllMarkers("org.sonarlint.eclipse.core.sonarlintOnTheFlyProblem");
        project.deleteAllMarkers("org.sonarlint.eclipse.core.sonarlintReportProblem");
        SonarLintCorePlugin.clearIssueTracker(project);
    }

    @Override
    public void updateConfig(String url, @Nullable String organization, String username, String password, boolean notificationsEnabled) {
        this.host = url;
        this.organization = organization;
        this.hasAuth = StringUtils.isNotBlank(username) || StringUtils.isNotBlank(password);
        this.notificationsEnabled = notificationsEnabled;
        SonarLintCorePlugin.getServersManager().updateServer(this, username, password);
    }

    @Override
    public AnalysisResults runAnalysis(ConnectedAnalysisConfiguration config, IssueListener issueListener, IProgressMonitor monitor) {
        return this.client.analyze(config, issueListener, null, (ProgressMonitor)new WrappedProgressMonitor(monitor, "Analysis"));
    }

    @Override
    public synchronized RuleDetails getRuleDescription(String ruleKey) {
        return this.client.getRuleDetails(ruleKey);
    }

    public void stop() {
        this.client.stop(false);
    }

    @Override
    public synchronized void updateStorage(IProgressMonitor monitor) {
        UpdateResult updateResult = this.client.update(this.getConfig(), (ProgressMonitor)new WrappedProgressMonitor(monitor, "Update configuration from server '" + this.getId() + "'"));
        Collection tooOld = updateResult.analyzers().stream().filter(SonarAnalyzer::sonarlintCompatible).filter(Server::tooOld).collect(Collectors.toList());
        if (!tooOld.isEmpty()) {
            SonarLintLogger.get().error(Server.buildMinimumVersionFailMessage(tooOld));
        }
        this.updateStatus = updateResult.status();
        this.hasUpdates = false;
    }

    private static boolean tooOld(SonarAnalyzer analyzer) {
        if (analyzer.minimumVersion() != null && analyzer.version() != null) {
            Version minimum = Version.parseVersion((String)analyzer.minimumVersion());
            Version version = Version.parseVersion((String)analyzer.version());
            return version.compareTo(minimum) < 0;
        }
        return false;
    }

    private static String buildMinimumVersionFailMessage(Collection<SonarAnalyzer> failingAnalyzers) {
        return "The following plugins do not meet the required minimum versions, please upgrade them on your SonarQube server:\n  " + failingAnalyzers.stream().map(p -> String.valueOf(p.key()) + " (installed: " + p.version() + ", minimum: " + p.minimumVersion() + ")").collect(Collectors.joining("\n  "));
    }

    @Override
    public void updateModuleList(IProgressMonitor monitor) {
        this.client.downloadAllModules(this.getConfig(), (ProgressMonitor)new WrappedProgressMonitor(monitor, "Download modules list from server '" + this.getId() + "'"));
    }

    @Override
    public List<ISonarLintProject> getBoundProjects() {
        ArrayList<ISonarLintProject> result = new ArrayList<ISonarLintProject>();
        for (ISonarLintProject project : ProjectsProviderUtils.allProjects()) {
            SonarLintProjectConfiguration projectConfig;
            if (!project.isOpen() || !Objects.equals((projectConfig = SonarLintProjectConfiguration.read(project.getScopeContext())).getServerId(), this.id)) continue;
            result.add(project);
        }
        return result;
    }

    @Override
    public synchronized void updateProjectStorage(String moduleKey, IProgressMonitor monitor) {
        this.client.updateModule(this.getConfig(), moduleKey, (ProgressMonitor)new WrappedProgressMonitor(monitor, "Update configuration from server '" + this.getId() + "' for module '" + moduleKey + "'"));
    }

    public static IStatus testConnection(String url, @Nullable String organization, @Nullable String username, @Nullable String password) {
        try {
            WsHelperImpl helper;
            ValidationResult testConnection;
            ServerConfiguration.Builder builder = Server.getConfigBuilderNoCredentials(url, organization);
            if (StringUtils.isNotBlank(username) || StringUtils.isNotBlank(password)) {
                builder.credentials(username, password);
            }
            if ((testConnection = (helper = new WsHelperImpl()).validateConnection(builder.build())).success()) {
                return new Status(0, "org.sonarlint.eclipse.core", "Successfully connected!");
            }
            return new Status(4, "org.sonarlint.eclipse.core", testConnection.message());
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownHostException) {
                return new Status(4, "org.sonarlint.eclipse.core", "Unknown host: " + url);
            }
            SonarLintLogger.get().debug(e.getMessage(), e);
            return new Status(4, "org.sonarlint.eclipse.core", e.getMessage(), (Throwable)e);
        }
    }

    public static TextSearchIndex<RemoteOrganization> getOrganizationsIndex(String url, String username, String password, IProgressMonitor monitor) {
        ServerConfiguration.Builder builder = Server.getConfigBuilderNoCredentials(url, null);
        if (StringUtils.isNotBlank(username) || StringUtils.isNotBlank(password)) {
            builder.credentials(username, password);
        }
        WsHelperImpl helper = new WsHelperImpl();
        TextSearchIndex index = new TextSearchIndex();
        for (RemoteOrganization org : helper.listOrganizations(builder.build(), (ProgressMonitor)new WrappedProgressMonitor(monitor, "Fetch organizations"))) {
            index.index((Object)org, String.valueOf(org.getKey()) + " " + org.getName());
        }
        return index;
    }

    public ServerConfiguration getConfig() {
        ServerConfiguration.Builder builder = Server.getConfigBuilderNoCredentials(this.getHost(), this.getOrganization());
        if (this.hasAuth()) {
            try {
                builder.credentials(ServersManager.getUsername(this), ServersManager.getPassword(this));
            }
            catch (StorageException e) {
                throw new IllegalStateException("Unable to read server credentials from storage: " + e.getMessage(), e);
            }
        }
        return builder.build();
    }

    private static ServerConfiguration.Builder getConfigBuilderNoCredentials(String url, @Nullable String organization) {
        IProxyData[] proxyDataForHost;
        ServerConfiguration.Builder builder = ServerConfiguration.builder().url(url).organizationKey(organization).userAgent("SonarLint Eclipse " + SonarLintUtils.getPluginVersion());
        IProxyService proxyService = SonarLintCorePlugin.getInstance().getProxyService();
        try {
            proxyDataForHost = proxyService.select(new URL(url).toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalStateException("Invalid URL for server: " + url, e);
        }
        IProxyData[] iProxyDataArray = proxyDataForHost;
        int n = proxyDataForHost.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData data = iProxyDataArray[n2];
            if (data.getHost() != null) {
                builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(data.getHost(), data.getPort())));
                if (!data.isRequiresAuthentication()) break;
                builder.proxyCredentials(data.getUserId(), data.getPassword());
                break;
            }
            ++n2;
        }
        return builder;
    }

    public static boolean checkNotificationsSupported(String url, String organization, String username, String password) {
        ServerConfiguration.Builder builder = Server.getConfigBuilderNoCredentials(url, organization);
        if (StringUtils.isNotBlank(username) || StringUtils.isNotBlank(password)) {
            builder.credentials(username, password);
        }
        return SonarQubeNotifications.get().isSupported(builder.build());
    }

    @Override
    public TextSearchIndex<RemoteModule> getModuleIndex() {
        Map allModulesByKey = this.client.allModulesByKey();
        TextSearchIndex index = new TextSearchIndex();
        for (RemoteModule module : allModulesByKey.values()) {
            index.index((Object)module, String.valueOf(module.getKey()) + " " + module.getName());
        }
        return index;
    }

    @Override
    public Map<String, RemoteModule> getRemoteModules() {
        return this.client.allModulesByKey();
    }

    @Override
    public void addServerListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeServerListener(IServerListener listener) {
        this.listeners.remove(listener);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Server)) {
            return false;
        }
        return ((Server)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public ConnectedSonarLintEngine getEngine() {
        return this.client;
    }

    @Override
    public boolean isSonarCloud() {
        return SONARCLOUD_URL.equals(this.host);
    }

    @Override
    public boolean areNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    public Server setNotificationsEnabled(boolean value) {
        this.notificationsEnabled = value;
        return this;
    }
}

